/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.WithSprite;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.klimt.sprite.SpriteColorBuilder4096;
import net.sourceforge.plantuml.klimt.sprite.SpriteGrayLevel;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public final class CommandFactorySprite
implements SingleMultiFactoryCommand<WithSprite> {
    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(CommandFactorySprite.class.getName() + "multi", RegexLeaf.start(), new RegexLeaf("sprite"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\$?"), new RegexLeaf("NAME", "([-.%pLN_]+)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("DIM", "\\[(\\d+)x(\\d+)/(?:(\\d+)(z)?|(color))\\]")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(CommandFactorySprite.class.getName() + "single", RegexLeaf.start(), new RegexLeaf("sprite"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\$?"), new RegexLeaf("NAME", "([-.%pLN_]+)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("DIM", "\\[(\\d+)x(\\d+)/(?:(\\d+)(z)|(color))\\]")), RegexLeaf.spaceOneOrMore(), new RegexLeaf("DATA", "([-_A-Za-z0-9]+)"), RegexLeaf.end());
    }

    @Override
    public Command<WithSprite> createSingleLine() {
        return new SingleLineCommand2<WithSprite>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(WithSprite system, LineLocation location, RegexResult arg) {
                return CommandFactorySprite.this.executeInternal(system, arg, Arrays.asList(arg.get("DATA", 0)));
            }
        };
    }

    @Override
    public Command<WithSprite> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<WithSprite>(this.getRegexConcatMultiLine(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH){

            @Override
            public String getPatternEnd() {
                return "^end[%s]?sprite|\\}$";
            }

            @Override
            protected CommandExecutionResult executeNow(WithSprite system, BlocLines lines) {
                lines = lines.trim().removeEmptyLines();
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1);
                if ((lines = lines.removeEmptyColumns()).size() == 0) {
                    return CommandExecutionResult.error("No sprite defined.");
                }
                return CommandFactorySprite.this.executeInternal(system, line0, lines.getLinesAsStringForSprite());
            }
        };
    }

    private CommandExecutionResult executeInternal(WithSprite system, RegexResult line0, List<String> strings) {
        Sprite sprite;
        if (line0.get("DIM", 0) == null) {
            sprite = SpriteGrayLevel.GRAY_16.buildSprite(-1, -1, strings);
        } else {
            int width = Integer.parseInt(line0.get("DIM", 0));
            int height = Integer.parseInt(line0.get("DIM", 1));
            if (line0.get("DIM", 4) == null) {
                int nbLevel = Integer.parseInt(line0.get("DIM", 2));
                if (nbLevel != 4 && nbLevel != 8 && nbLevel != 16) {
                    return CommandExecutionResult.error("Only 4, 8 or 16 graylevel are allowed.");
                }
                SpriteGrayLevel level = SpriteGrayLevel.get(nbLevel);
                if (line0.get("DIM", 3) == null) {
                    sprite = level.buildSprite(width, height, strings);
                } else {
                    sprite = level.buildSpriteZ(width, height, this.concat(strings));
                    if (sprite == null) {
                        return CommandExecutionResult.error("Cannot decode sprite.");
                    }
                }
            } else {
                sprite = SpriteColorBuilder4096.buildSprite(strings);
            }
        }
        system.addSprite(line0.get("NAME", 0), sprite);
        return CommandExecutionResult.ok();
    }

    private String concat(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String s2 : strings) {
            sb.append(StringUtils.trin(s2));
        }
        return sb.toString();
    }
}

