/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.v2.ao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.ao.entity.PersistenceEntity;
import com.moveworkforward.util.ConnectorUtil;
import com.moveworkforward.v2.ao.Persistence;
import com.moveworkforward.v2.ao.PersistentConverter;
import com.moveworkforward.v2.ao.PluginRepository;
import com.moveworkforward.v2.model.IdModel;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.Case;
import net.java.ao.schema.GetterFieldNameResolver;
import net.java.ao.schema.IgnoredFieldNameResolver;
import net.java.ao.schema.IsAFieldNameResolver;
import net.java.ao.schema.NullFieldNameResolver;
import net.java.ao.schema.RelationalFieldNameResolver;
import net.java.ao.schema.SetterFieldNameResolver;
import net.java.ao.schema.UnderscoreFieldNameConverter;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AbstractPluginRepository<K extends Entity & PersistenceEntity>
implements PluginRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPluginRepository.class);
    public static final int NO_LIMIT = -1;
    public static final int NO_OFFSET = -1;
    protected final ActiveObjects activeObjects;
    protected final Class<K> persistentClass;
    protected final TransactionTemplate transactionTemplate;
    private final String fields;
    protected ObjectMapper objectMapper = ConnectorUtil.createObjectMapper();

    public AbstractPluginRepository(ActiveObjects activeObjects, TransactionTemplate transactionTemplate) {
        this.activeObjects = Preconditions.checkNotNull(activeObjects);
        this.transactionTemplate = transactionTemplate;
        this.persistentClass = this.getPersistentClass();
        this.fields = String.join((CharSequence)",", this.getFieldNames(this.persistentClass));
    }

    public static <T> String getType(Class<T> tClass) {
        Persistence persistence = (Persistence)AnnotationUtils.findAnnotation(tClass, Persistence.class);
        if (persistence != null) {
            return persistence.entityType();
        }
        EntityType entityType = (EntityType)AnnotationUtils.findAnnotation(tClass, EntityType.class);
        return entityType == null ? tClass.getSimpleName().toUpperCase() : entityType.value();
    }

    protected String getFields() {
        return this.fields;
    }

    protected Set<String> getFieldNames(Class<K> persistentClass) {
        UnderscoreFieldNameConverter nameConverter = new UnderscoreFieldNameConverter(Case.UPPER, Lists.newArrayList(new IgnoredFieldNameResolver(), new RelationalFieldNameResolver(), new GetterFieldNameResolver(), new SetterFieldNameResolver(), new IsAFieldNameResolver(), new NullFieldNameResolver()));
        LinkedHashSet<String> collectedFields = new LinkedHashSet<String>();
        collectedFields.add("ID");
        for (Method declaredMethod : persistentClass.getDeclaredMethods()) {
            if (!declaredMethod.getName().startsWith("get")) continue;
            collectedFields.add(nameConverter.getName(declaredMethod));
        }
        return collectedFields;
    }

    protected Class<K> getPersistentClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public <T> T save(T target) {
        PersistenceEntity entity = this.convertToPersistence(target);
        return (T)this.transactionTemplate.execute(() -> {
            List entities;
            log.info("saving plugin setting: '{}' , type: {}", (Object)entity.getKey(), (Object)entity.getType());
            boolean newEntity = entity.getID() == 0;
            List<Object> list = entities = newEntity ? Collections.emptyList() : Arrays.asList(this.activeObjects.find(this.persistentClass, this.idQuery(entity.getID(), entity.getType())));
            if (!newEntity && entities.isEmpty()) {
                throw new RuntimeException("Can not update entity with id " + entity.getID() + " because it doesn't exist");
            }
            Entity pluginSetting = null;
            try {
                K existingEntity = this.doGetByKey(entity.getKey(), target.getClass());
                if (entities.isEmpty()) {
                    if (existingEntity != null) {
                        throw new RuntimeException("Key: '" + entity.getKey() + "' already exists for another id, can't be overridden");
                    }
                    pluginSetting = (Entity)this.activeObjects.create(this.persistentClass, this.createParams(entity));
                    log.info("New entity: '{}' has been saved", (Object)((PersistenceEntity)pluginSetting).getKey());
                } else {
                    if (existingEntity != null && ((PersistenceEntity)existingEntity).getID() != entity.getID()) {
                        throw new RuntimeException("Key: '" + entity.getKey() + "' already exists for another id, can't be overridden");
                    }
                    pluginSetting = (Entity)entities.get(0);
                    this.updateParams(pluginSetting, entity);
                    log.info("SettingEntity: '{}' was updated", (Object)entity.getKey());
                }
                pluginSetting.save();
            }
            catch (Exception e) {
                log.error("Can't save setting: " + entity.getKey(), (Throwable)e);
                throw new RuntimeException(e);
            }
            return this.convertFromPersistence(pluginSetting, target.getClass());
        });
    }

    protected <T> PersistenceEntity convertToPersistence(T entity) {
        Class<? extends PersistentConverter> converter;
        Persistence persistence = (Persistence)AnnotationUtils.findAnnotation(entity.getClass(), Persistence.class);
        if (persistence != null && (converter = persistence.converter()) != null) {
            return converter.newInstance().convertToAo(entity);
        }
        throw new IllegalArgumentException("No converter to AO is found");
    }

    protected <T> T convertFromPersistence(K entity, Class<T> clazz) {
        if (entity == null || ((PersistenceEntity)entity).getContent() == null) {
            return null;
        }
        Object result = this.objectMapper.readValue(((PersistenceEntity)entity).getContent(), clazz);
        if (result instanceof IdModel) {
            ((IdModel)result).setId(((PersistenceEntity)entity).getID());
        }
        return (T)result;
    }

    protected void updateParams(K existingEntity, PersistenceEntity newEntity) {
        ((PersistenceEntity)existingEntity).setKey(newEntity.getKey());
        ((PersistenceEntity)existingEntity).setTag(newEntity.getTag());
        ((PersistenceEntity)existingEntity).setContent(newEntity.getContent());
    }

    protected Map<String, Object> createParams(PersistenceEntity entity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("TYPE", entity.getType());
        params.put("KEY", entity.getKey());
        params.put("TAG", entity.getTag());
        params.put("CONTENT", entity.getContent());
        return params;
    }

    @Override
    public <T> T get(int id, Class<T> clazz) {
        String entityType = AbstractPluginRepository.getType(clazz);
        return (T)this.transactionTemplate.execute(() -> {
            log.info("Get entity by id: {} , type: {}", (Object)id, (Object)entityType);
            List<RawEntity> entities = Arrays.asList(this.activeObjects.find(this.persistentClass, this.idQuery(id, entityType)));
            if (entities.isEmpty()) {
                return null;
            }
            return this.convertFromPersistence((Entity)entities.get(0), clazz);
        });
    }

    @Override
    public <T> T delete(int id, Class<T> clazz) {
        String entityType = AbstractPluginRepository.getType(clazz);
        return (T)this.transactionTemplate.execute(() -> {
            log.info("Delete entity for id:{} , type: {}", (Object)id, (Object)entityType);
            List<RawEntity> entities = Arrays.asList(this.activeObjects.find(this.persistentClass, this.idQuery(id, entityType)));
            if (entities.isEmpty()) {
                log.warn("Entity with id {} is not found, nothing to delete", (Object)id);
                return null;
            }
            this.activeObjects.delete(new RawEntity[]{entities.get(0)});
            return this.convertFromPersistence((Entity)entities.get(0), clazz);
        });
    }

    @Override
    public <T> T deleteByKey(String key, Class<T> clazz) {
        String entityType = AbstractPluginRepository.getType(clazz);
        return (T)this.transactionTemplate.execute(() -> {
            log.info("Delete entity for key: {} , type: {}", (Object)key, (Object)entityType);
            List<RawEntity> entities = Arrays.asList(this.activeObjects.find(this.persistentClass, Query.select().where("TYPE = ? AND KEY = ?", new Object[]{entityType, key})));
            if (entities.isEmpty()) {
                log.warn("Entity with key {} is not found, nothing to delete", (Object)key);
                return null;
            }
            this.activeObjects.delete(new RawEntity[]{entities.get(0)});
            return this.convertFromPersistence((Entity)entities.get(0), clazz);
        });
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz) {
        return this.getAll(-1, -1, clazz);
    }

    @Override
    public <T> List<T> getAll(int limit, int offset, Class<T> clazz) {
        String entityType = AbstractPluginRepository.getType(clazz);
        return (List)this.transactionTemplate.execute(() -> {
            log.info("Loading all entities, type: {}", (Object)entityType);
            Query query = Query.select((String)this.fields).where("TYPE = ?", new Object[]{entityType}).limit(limit).offset(offset).order("ID ASC");
            ArrayList result = new ArrayList();
            this.activeObjects.stream(this.persistentClass, query, t2 -> result.add(this.convertFromPersistence(t2, clazz)));
            return result;
        });
    }

    @Override
    public <T> int deleteAll(Class<T> clazz) {
        String entityType = AbstractPluginRepository.getType(clazz);
        return (Integer)this.transactionTemplate.execute(() -> {
            log.info("Delete all entities, type: {}", (Object)entityType);
            return this.activeObjects.deleteWithSQL(this.persistentClass, "TYPE = ?", new Object[]{entityType});
        });
    }

    @Override
    public <T> int deleteByTag(String tag, Class<T> clazz) {
        String entityType = AbstractPluginRepository.getType(clazz);
        return (Integer)this.transactionTemplate.execute(() -> {
            log.info("Delete entities by tag: {} , type: {}", (Object)tag, (Object)entityType);
            return this.activeObjects.deleteWithSQL(this.persistentClass, "TYPE = ? AND TAG = ?", new Object[]{entityType, tag});
        });
    }

    @Override
    public <T> List<T> getByTag(String tag, Class<T> clazz) {
        return this.getByTag(tag, -1, -1, clazz);
    }

    @Override
    public <T> List<T> getByTag(String tag, int limit, int offset, Class<T> clazz) {
        String entityType = AbstractPluginRepository.getType(clazz);
        return (List)this.transactionTemplate.execute(() -> {
            log.info("Get entities by tag: {} , type: {}", (Object)tag, (Object)entityType);
            Query query = Query.select((String)this.fields).where("TYPE = ? AND TAG = ?", new Object[]{entityType, tag}).limit(limit).offset(offset);
            ArrayList result = new ArrayList();
            this.activeObjects.stream(this.persistentClass, query, t2 -> result.add(this.convertFromPersistence(t2, clazz)));
            return result;
        });
    }

    @Override
    public <T> List<T> getByTagLike(String tagPattern, int limit, int offset, Class<T> clazz) {
        String entityType = AbstractPluginRepository.getType(clazz);
        if (StringUtils.isBlank((CharSequence)tagPattern)) {
            return this.getAll(limit, offset, clazz);
        }
        return (List)this.transactionTemplate.execute(() -> {
            log.info("Get entities by tag like: {} , type: {}", (Object)tagPattern, (Object)entityType);
            Query query = Query.select((String)this.fields).where("TYPE = ? AND TAG like ?", new Object[]{entityType, tagPattern}).limit(limit).offset(offset).order("ID ASC");
            ArrayList result = new ArrayList();
            this.activeObjects.stream(this.persistentClass, query, t2 -> result.add(this.convertFromPersistence(t2, clazz)));
            return result;
        });
    }

    @Override
    public <T> int count(String tagPattern, Class<T> clazz) {
        String entityType = AbstractPluginRepository.getType(clazz);
        if (StringUtils.isBlank((CharSequence)tagPattern)) {
            return this.count(clazz);
        }
        return (Integer)this.transactionTemplate.execute(() -> {
            Query query = Query.select().where("TYPE = ? AND TAG like ?", new Object[]{entityType, tagPattern});
            return this.activeObjects.count(this.persistentClass, query);
        });
    }

    @Override
    public <T> T getByKey(String key, Class<T> clazz) {
        return this.convertFromPersistence(this.doGetByKey(key, clazz), clazz);
    }

    private <T> K doGetByKey(String key, Class<T> clazz) {
        String entityType = AbstractPluginRepository.getType(clazz);
        return (K)((Entity)this.transactionTemplate.execute(() -> {
            log.info("Get entity by key: {} , type: {}", (Object)entityType);
            List<RawEntity> entities = Arrays.asList(this.activeObjects.find(this.persistentClass, Query.select().where("TYPE = ? AND KEY = ?", new Object[]{entityType, key})));
            if (entities.isEmpty()) {
                log.info("Entity with key {} is not found", (Object)key);
                return null;
            }
            if (entities.size() > 1) {
                log.warn("More than one entity is found by key: {}", (Object)key);
            }
            return (Entity)entities.get(0);
        }));
    }

    @Override
    public <T> int count(Class<T> clazz) {
        String entityType = AbstractPluginRepository.getType(clazz);
        return (Integer)this.transactionTemplate.execute(() -> this.activeObjects.count(this.persistentClass, Query.select().where("TYPE = ?", new Object[]{entityType})));
    }

    protected Query idQuery(Integer id, String entityType) {
        return Query.select().where("TYPE = ? AND ID = ?", new Object[]{entityType, id});
    }
}

