/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.statistics.job;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.moveworkforward.statistics.job.StatisticsJobRunner;
import com.moveworkforward.util.MwfPropertyUtils;
import java.util.Random;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class StatisticsJobScheduler
implements LifecycleAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsJobScheduler.class);
    public static final JobId JOB_ID = JobId.of((String)"jigit-StatisticsReport");
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)"jigit-StatisticsReport");
    private static final int HOURS_BOUND = 24;
    private static final int MINUTES_BOUND = 60;
    private final SchedulerService schedulerService;

    @Autowired
    public StatisticsJobScheduler(@ComponentImport SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void onStart() {
        try {
            if (StringUtils.isNotBlank((CharSequence)MwfPropertyUtils.getInstance().getProperty(MwfPropertyUtils.STATISTICS_URL))) {
                this.registerJobRunner();
                this.scheduleJob();
            } else {
                log.warn("Statistics URL is not set. Job {} will not be scheduled", (Object)JOB_ID);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            this.unregisterJobRunner();
        }
    }

    public void onStop() {
        this.unregisterJobRunner();
    }

    public void registerJobRunner() {
        log.info("Register job runner {}", (Object)JOB_RUNNER_KEY);
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new StatisticsJobRunner());
    }

    public void unregisterJobRunner() {
        this.unscheduleJob();
        log.info("Unregister job runner {}", (Object)JOB_RUNNER_KEY);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private void scheduleJob() {
        this.unscheduleJob();
        String cronExpression = this.getCronExpression();
        Schedule schedule = Schedule.forCronExpression((String)cronExpression);
        try {
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(schedule));
            log.info("Job {}({}) has been scheduled with schedule: {}", new Object[]{JOB_RUNNER_KEY, JOB_ID, schedule});
        }
        catch (SchedulerServiceException e) {
            log.error("Error while scheduling jobs", (Throwable)e);
        }
    }

    private String getCronExpression() {
        String cronExpression = MwfPropertyUtils.getInstance().getProperty(MwfPropertyUtils.STATISTICS_CRON_EXPRESSION);
        if (StringUtils.isNotBlank((CharSequence)cronExpression)) {
            return cronExpression;
        }
        String cronPattern = "0 %d %d ? * SUN *";
        int hour = new Random().nextInt(24);
        int minute = new Random().nextInt(60);
        return String.format(cronPattern, minute, hour);
    }

    private void unscheduleJob() {
        log.info("Unschedule job {}", (Object)JOB_ID);
        this.schedulerService.unscheduleJob(JOB_ID);
    }
}

