/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.rest;

import com.google.common.collect.ImmutableMap;
import com.moveworkforward.component.UserSurveyManager;
import com.moveworkforward.model.User;
import com.moveworkforward.model.UserSurvey;
import com.moveworkforward.util.MwfPropertyUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractUserSurveyController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractUserSurveyController.class);
    protected final UserSurveyManager surveyManager;
    protected final Environment environment;

    public AbstractUserSurveyController(UserSurveyManager surveyManager, Environment environment) {
        this.surveyManager = surveyManager;
        this.environment = environment;
    }

    @GET
    @Path(value="/{surveyId}")
    public List<UserSurvey> getSurveys(@PathParam(value="surveyId") String surveyId, @QueryParam(value="userKey") String userKey) {
        User user = this.getCurrentUser();
        if (userKey != null && (user.getUserKey().equals(userKey) || this.isAdmin(user))) {
            UserSurvey survey = this.surveyManager.getSurvey(userKey, surveyId);
            if (survey == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(survey);
        }
        if (this.isAdmin(user)) {
            return this.surveyManager.getSurveys(surveyId);
        }
        return Collections.emptyList();
    }

    protected abstract boolean isAdmin(User var1);

    @POST
    @Path(value="/submit/{surveyId}")
    public UserSurvey submitSurvey(@PathParam(value="surveyId") String surveyId) {
        User user = this.getCurrentUser();
        return this.surveyManager.submitSurvey(user.getUserKey(), surveyId);
    }

    @POST
    @Path(value="/close/{surveyId}")
    public UserSurvey closeSurvey(@PathParam(value="surveyId") String surveyId) {
        User user = this.getCurrentUser();
        return this.surveyManager.cancelSurvey(user.getUserKey(), surveyId);
    }

    @POST
    @Path(value="/reset/{surveyId}")
    public void resetSurvey(@PathParam(value="surveyId") String surveyId) {
        if (this.isAdmin(this.getCurrentUser())) {
            this.surveyManager.resetSurvey(surveyId);
        }
    }

    @DELETE
    @Path(value="/periods/reset")
    public Map<String, Long> resetPeriods() {
        if (!MwfPropertyUtils.getInstance().isDevMode(this.environment)) {
            throw new RuntimeException("This operation is not allowed in production mode");
        }
        if (this.isAdmin(this.getCurrentUser())) {
            this.surveyManager.resetPeriods();
            return ImmutableMap.of("submissionPeriod", this.surveyManager.getSubmissionPeriod(), "licenseCancellationPeriod", this.surveyManager.getLicenseCancellationPeriod(), "evaluationCancellationPeriod", this.surveyManager.getEvaluationCancellationPeriod());
        }
        return Collections.emptyMap();
    }

    @GET
    @Path(value="/periods")
    public Map<String, Long> getPeriods() {
        if (!MwfPropertyUtils.getInstance().isDevMode(this.environment)) {
            throw new RuntimeException("This operation is not allowed in production mode");
        }
        if (this.isAdmin(this.getCurrentUser())) {
            return ImmutableMap.of("submissionPeriod", this.surveyManager.getSubmissionPeriod(), "licenseCancellationPeriod", this.surveyManager.getLicenseCancellationPeriod(), "evaluationCancellationPeriod", this.surveyManager.getEvaluationCancellationPeriod());
        }
        return Collections.emptyMap();
    }

    @POST
    @Path(value="/periods")
    public Map<String, Long> setSubmissionPeriods(@QueryParam(value="submissionPeriod") @DefaultValue(value="0") Long submissionPeriod, @QueryParam(value="licenseCancellationPeriod") @DefaultValue(value="0") Long licenseCancellationPeriod, @QueryParam(value="evaluationCancellationPeriod") @DefaultValue(value="0") Long evaluationCancellationPeriod) {
        if (!MwfPropertyUtils.getInstance().isDevMode(this.environment)) {
            throw new RuntimeException("This operation is not allowed in production mode");
        }
        if (this.isAdmin(this.getCurrentUser())) {
            if (submissionPeriod > 0L) {
                this.surveyManager.setSubmissionPeriod(submissionPeriod);
            }
            if (licenseCancellationPeriod > 0L) {
                this.surveyManager.setLicenseCancellationPeriod(licenseCancellationPeriod);
            }
            if (evaluationCancellationPeriod > 0L) {
                this.surveyManager.setEvaluationCancellationPeriod(evaluationCancellationPeriod);
            }
            return ImmutableMap.of("submissionPeriod", this.surveyManager.getSubmissionPeriod(), "licenseCancellationPeriod", this.surveyManager.getLicenseCancellationPeriod(), "evaluationCancellationPeriod", this.surveyManager.getEvaluationCancellationPeriod());
        }
        return Collections.emptyMap();
    }

    protected abstract User getCurrentUser();
}

