/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.rest;

import com.google.common.collect.ImmutableMap;
import com.moveworkforward.statistics.model.StatisticsMessage;
import com.moveworkforward.statistics.service.StatisticsService;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatisticsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractStatisticsController.class);
    protected final StatisticsService statisticsService;

    public AbstractStatisticsController(StatisticsService statisticsService) {
        this.statisticsService = statisticsService;
    }

    @GET
    public StatisticsMessage getStatisticsMessage() {
        this.checkGlobalAdminPermissions();
        return this.statisticsService.generateMessage();
    }

    @DELETE
    public void deleteStatistics() {
        this.checkGlobalAdminPermissions();
        this.statisticsService.cleanUp();
    }

    @GET
    @Path(value="/send")
    public Map<String, String> sendStatistics() {
        this.checkGlobalAdminPermissions();
        if (this.statisticsService.sendStatistics()) {
            return ImmutableMap.of("status", "ok");
        }
        return ImmutableMap.of("status", "ok", "message", "Statistics sending is disabled");
    }

    protected abstract void checkGlobalAdminPermissions();
}

