/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.model;

import com.moveworkforward.model.AbstractConfiguration;
import com.moveworkforward.model.BaseDestination;
import com.moveworkforward.model.ConfigurationLevel;
import com.moveworkforward.model.Delivery;
import com.moveworkforward.model.LevelPluginEntity;
import com.moveworkforward.model.ScheduledPluginEntity;
import com.moveworkforward.model.Source;
import com.moveworkforward.model.User;
import com.moveworkforward.util.DayTimeUtil;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;

@JsonAutoDetect
public abstract class AbstractScheduledReportConfiguration<D extends BaseDestination, S extends Source, L extends ConfigurationLevel>
extends AbstractConfiguration<D, S>
implements ScheduledPluginEntity,
LevelPluginEntity<L> {
    private String key;
    private User owner;
    private Delivery delivery;

    public AbstractScheduledReportConfiguration() {
        this.destinations.add(this.createDestination());
    }

    protected abstract D createDestination();

    @Override
    public String getKey() {
        if (StringUtils.isBlank((CharSequence)this.key)) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }

    @Override
    @JsonIgnore
    public D getDestination() {
        return (D)((BaseDestination)this.getDestinations().get(0));
    }

    @Override
    public String getReportTime() {
        return this.delivery == null ? "" : DayTimeUtil.getReportTime(this.delivery);
    }

    @Override
    @Generated
    public User getOwner() {
        return this.owner;
    }

    @Override
    @Generated
    public Delivery getDelivery() {
        return this.delivery;
    }

    @Override
    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    @Generated
    public void setOwner(User owner) {
        this.owner = owner;
    }

    @Generated
    public void setDelivery(Delivery delivery) {
        this.delivery = delivery;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractScheduledReportConfiguration(super=" + super.toString() + ", key=" + this.key + ", owner=" + this.owner + ", delivery=" + this.delivery + ")";
    }

    public static enum DeliveryFrequency {
        WEEKLY,
        DAILY,
        WORKING_DAY,
        SCHEDULED;

    }
}

