/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.ao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.moveworkforward.ao.entity.PersistenceEntity;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.ao.impl.AbstractPluginRepository;
import com.moveworkforward.ao.impl.CachedRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import lombok.Generated;
import lombok.NonNull;
import net.java.ao.Entity;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCachedPluginRepository<T extends PluginEntity, K extends PersistenceEntity & Entity>
extends AbstractPluginRepository<T, K>
implements CachedRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCachedPluginRepository.class);
    protected CacheManager cacheManager;
    protected Cache<String, List<T>> cache;
    protected CacheSettings cacheSettings;

    public AbstractCachedPluginRepository(ActiveObjects activeObjects, CacheManager cacheManager, Class<K> persistentClass, TransactionTemplate transactionTemplate) {
        super(activeObjects, persistentClass, transactionTemplate);
        this.cacheManager = cacheManager;
        this.cacheSettings = new CacheSettingsBuilder().remote().replicateViaInvalidation().maxEntries(500).expireAfterAccess(1440L, TimeUnit.MINUTES).build();
        this.cache = cacheManager.getCache(this.getClass().getName() + "." + this.entityType, this::load, this.cacheSettings);
    }

    @Override
    public T save(T entity) {
        T result = super.save(entity);
        this.invalidateCache();
        return result;
    }

    @Override
    public T get(int id) {
        return (T)((PluginEntity)this.getData(String.valueOf(id), CacheStrategy.ID).stream().findFirst().orElse(null));
    }

    @Override
    public T delete(int id) {
        Object result = super.delete(id);
        this.invalidateCache();
        return result;
    }

    @Override
    public T deleteByKey(String key) {
        Object result = super.deleteByKey(key);
        this.invalidateCache();
        return result;
    }

    @Override
    public List<T> getAll() {
        return this.getData(null, CacheStrategy.TYPE);
    }

    @Override
    public int deleteAll() {
        int count = super.deleteAll();
        this.invalidateCache();
        return count;
    }

    @Override
    public T getByKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (T)((PluginEntity)this.getData(key, CacheStrategy.KEY).stream().findFirst().orElse(null));
    }

    @Override
    public List<T> deleteByTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        List result = super.deleteByTag(tag);
        this.invalidateCache();
        return result;
    }

    @Override
    public List<T> getByTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        return this.getData(tag, CacheStrategy.TAG);
    }

    @Override
    public void invalidateCache() {
        this.cache.removeAll();
    }

    @Nonnull
    protected List<T> getData(String key, CacheStrategy cacheStrategy) {
        String compositeKey = cacheStrategy.createCompositeKey(key);
        List result = null;
        boolean exception = false;
        try {
            result = (List)this.cache.get((Object)compositeKey);
        }
        catch (Exception e) {
            log.warn("Can't get data from cache, reload");
            exception = true;
        }
        if (exception || result == null) {
            this.cache.remove((Object)compositeKey);
            result = (List)this.cache.get((Object)compositeKey);
        }
        return Optional.ofNullable(result).map(ArrayList::new).orElse(new ArrayList());
    }

    @Nonnull
    protected List<T> load(@Nonnull String compositeKey) {
        List<T> result;
        Pair<CacheStrategy, String> pair = CacheStrategy.fromCompositeKey(compositeKey);
        switch ((CacheStrategy)((Object)pair.getKey())) {
            case ID: {
                result = this.loadById(Integer.parseInt((String)pair.getRight()));
                break;
            }
            case KEY: {
                result = this.loadByKey((String)pair.getRight());
                break;
            }
            case TAG: {
                result = this.loadByTag((String)pair.getRight());
                break;
            }
            default: {
                result = this.loadAll();
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected List<T> loadAll() {
        return AbstractCachedPluginRepository.super.getAll();
    }

    protected List<T> loadByTag(String tag) {
        return AbstractCachedPluginRepository.super.getByTag(tag);
    }

    protected List<T> loadByKey(String key) {
        return Optional.ofNullable(AbstractCachedPluginRepository.super.getByKey(key)).map(t2 -> new ArrayList<PluginEntity>(Collections.singletonList(t2))).orElse(new ArrayList());
    }

    protected List<T> loadById(int id) {
        return Optional.ofNullable(AbstractCachedPluginRepository.super.get(id)).map(t2 -> new ArrayList<PluginEntity>(Collections.singletonList(t2))).orElse(new ArrayList());
    }

    @Override
    public void updateCacheConfiguration(int maxEntries, int expirationInMinutes) {
        log.info("Old cache size: {} ", (Object)this.cache.getKeys().size());
        log.info("Previous settings: max entries {}, expiration {}", (Object)this.cacheSettings.getMaxEntries(), (Object)this.cacheSettings.getExpireAfterAccess());
        log.info("New settings: max entries {}, expiration {}(min)", (Object)maxEntries, (Object)expirationInMinutes);
        CacheSettings newCacheSettings = new CacheSettingsBuilder().remote().maxEntries(maxEntries).expireAfterAccess((long)expirationInMinutes, TimeUnit.MINUTES).replicateViaInvalidation().build();
        Cache newCache = this.cacheManager.getCache(this.getClass().getName() + "." + this.entityType, this::load, newCacheSettings);
        Cache<String, List<T>> oldCache = this.cache;
        this.cache = newCache;
        oldCache.removeAll();
        this.cacheSettings = newCacheSettings;
    }

    public static enum CacheStrategy {
        TAG,
        TYPE,
        ID,
        KEY;


        public static Pair<CacheStrategy, String> fromCompositeKey(String compositKey) {
            if (StringUtils.isBlank((CharSequence)compositKey) || !compositKey.contains(":")) {
                return null;
            }
            int idx = compositKey.indexOf(58);
            CacheStrategy cacheStrategy = CacheStrategy.valueOf(compositKey.substring(0, compositKey.indexOf(58)));
            String key = compositKey.substring(idx + 1);
            return ImmutablePair.of((Object)((Object)cacheStrategy), (Object)key);
        }

        public String createCompositeKey(String key) {
            return this.toString() + ":" + key;
        }
    }
}

