/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.validation;

import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.validation.LevelPermissionConstraint;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LevelPermissionValidator
implements ConstraintValidator<LevelPermissionConstraint, GitLabConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LevelPermissionValidator.class);
    @ComponentImport
    @Autowired
    private PermissionManager permissionManager;

    public static boolean isGlobalAdmin(PermissionManager permissionManager, ConfluenceUser confluenceUser) {
        return permissionManager.isConfluenceAdministrator((User)confluenceUser);
    }

    @Override
    public boolean isValid(GitLabConfiguration configuration, ConstraintValidatorContext context) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (LevelPermissionValidator.isGlobalAdmin(this.permissionManager, confluenceUser)) {
            return true;
        }
        if (GitLabConfiguration.Level.PERSONAL.equals(configuration.getLevel())) {
            return confluenceUser.getKey().getStringValue().equals(configuration.getUserKey());
        }
        return false;
    }
}

