/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciiUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsciiUtil.class);
    public static final String ASCII_PLUNTUML_BLOCK = "----";
    public static final String ASCII_MERMAID_BLOCK = "....";

    public String prepareMermaidContent(String content) {
        int index = -1;
        int startIndex = 0;
        do {
            int blockEndIndex;
            int blockStartIndex;
            if ((index = content.indexOf("[mermaid", startIndex)) > 0 && (blockStartIndex = this.getBlockIndex(content, ASCII_MERMAID_BLOCK, content.indexOf("]", index) + 1, true)) > 0 && (blockEndIndex = this.getBlockIndex(content, ASCII_MERMAID_BLOCK, blockStartIndex + ASCII_MERMAID_BLOCK.length(), false)) > 0) {
                try {
                    String mermaidBlock = content.substring(blockStartIndex + ASCII_MERMAID_BLOCK.length(), blockEndIndex);
                    StringBuilder builder = new StringBuilder();
                    builder.append("\n[source,mermaid]\n");
                    builder.append(ASCII_PLUNTUML_BLOCK);
                    builder.append(mermaidBlock);
                    builder.append("----\n");
                    String wholeMermaidBlock = content.substring(index, blockEndIndex + ASCII_MERMAID_BLOCK.length());
                    content = content.replace(wholeMermaidBlock, builder.toString());
                }
                catch (Exception e) {
                    log.error("Error while processing plantuml block", (Throwable)e);
                }
            }
            startIndex = index + 1;
        } while (index > 0);
        return content;
    }

    public String preparePlantUmlContent(String content) {
        int index = -1;
        int startIndex = 0;
        do {
            int blockEndIndex;
            int blockStartIndex;
            if ((index = content.indexOf("[plantuml", startIndex)) > 0 && (blockStartIndex = this.getBlockIndex(content, ASCII_PLUNTUML_BLOCK, content.indexOf("]", index) + 1, true)) > 0 && (blockEndIndex = this.getBlockIndex(content, ASCII_PLUNTUML_BLOCK, blockStartIndex + ASCII_PLUNTUML_BLOCK.length(), false)) > 0) {
                try {
                    String plantUmlBlock = content.substring(blockStartIndex + ASCII_PLUNTUML_BLOCK.length(), blockEndIndex);
                    StringBuilder builder = new StringBuilder();
                    builder.append("@startuml\n");
                    builder.append(plantUmlBlock);
                    builder.append("\n@enduml\n");
                    String wholePlantUmlBlock = content.substring(index, blockEndIndex + ASCII_PLUNTUML_BLOCK.length());
                    content = content.replace(wholePlantUmlBlock, this.getPlantUmlImage(builder.toString()));
                }
                catch (Exception e) {
                    log.error("Error while processing plantuml block", (Throwable)e);
                }
            }
            startIndex = index + 1;
        } while (index > 0);
        return content;
    }

    protected String getPlantUmlImage(String plantUmlBlock) throws IOException {
        SourceStringReader reader = new SourceStringReader(plantUmlBlock);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            reader.outputImage((OutputStream)os, new FileFormatOption(FileFormat.SVG));
            String string = new String(os.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
    }

    protected int getBlockIndex(String content, String blockDevider, int startIndex, boolean checkEmptyContent) {
        int index = content.indexOf(blockDevider, startIndex);
        if (index > 0 && checkEmptyContent) {
            String contentBetween = content.substring(startIndex, index);
            if (contentBetween.trim().isEmpty()) {
                return index;
            }
        } else {
            return index;
        }
        return -1;
    }
}

