/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.servlets;

import at.rumpelcoders.confluence.components.GitLabUserSurveyManager;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.service.GitLabConfigurationService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.component.UserSurveyManager;
import com.moveworkforward.model.User;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="settingsServlet")
public class SettingsServlet
extends HttpServlet {
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final SpaceManager spaceManager;
    private final GitLabConfigurationService configurationService;
    private final UserSurveyManager userSurveyManager;

    @Autowired
    public SettingsServlet(@ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer renderer, @ComponentImport SpaceManager spaceManager, GitLabConfigurationService configurationService, UserSurveyManager userSurveyManager) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.configurationService = configurationService;
        this.spaceManager = spaceManager;
        this.userSurveyManager = userSurveyManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserKey userkey = this.userManager.getRemoteUserKey();
        if (userkey == null) {
            this.redirectToLogin(request, response);
            return;
        }
        if (!this.userManager.isSystemAdmin(userkey)) {
            response.setStatus(403);
            response.getWriter().write("You don't have permissions");
            response.getWriter().flush();
            return;
        }
        List configurations = this.configurationService.getByTag("05f11044-da77-41a8-ac66-a9388ffd0925", GitLabConfiguration.Level.GLOBAL.toString());
        GitLabConfiguration configuration = CollectionUtils.isEmpty(configurations) ? new GitLabConfiguration() : (GitLabConfiguration)configurations.get(0);
        configuration = configuration.clone();
        configuration.setApiKey(configuration.getApiKey() == null ? "" : "********");
        configuration.setServerUrl(configuration.getServerUrl() == null ? "" : configuration.getServerUrl());
        configuration.setLevel(GitLabConfiguration.Level.GLOBAL);
        LinkedHashSet<String> spaceKeys = new LinkedHashSet<String>();
        if (CollectionUtils.isNotEmpty(configuration.getAllowedSpaces())) {
            spaceKeys.addAll(configuration.getAllowedSpaces());
        }
        if (CollectionUtils.isNotEmpty(configuration.getForbiddenSpaces())) {
            spaceKeys.addAll(configuration.getForbiddenSpaces());
        }
        HashMap<String, String> usedSpaces = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(spaceKeys)) {
            List spaces = this.spaceManager.getAllSpaces(SpacesQuery.newQuery().withSpaceKeys(spaceKeys).build());
            usedSpaces.putAll(spaces.stream().collect(Collectors.toMap(Space::getKey, Space::getName)));
        }
        Map<String, Object> surveyData = this.userSurveyManager.getSurveyData(this.getCurrentUser(), "ZQeG8ZUT", GitLabUserSurveyManager.SurveyLocation.GLOBAL);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("config", configuration);
        parameters.put("usedSpaces", usedSpaces);
        if (surveyData != null) {
            parameters.put("survey", surveyData);
        }
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("servlets/settings.vm", parameters, (Writer)response.getWriter());
    }

    private User getCurrentUser() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return new User(confluenceUser, confluenceUser.getKey().getStringValue(), confluenceUser.getName());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

