/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.service;

import at.rumpelcoders.confluence.ao.GitLabRepository;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.validator.GitLabRecordValidator;
import com.moveworkforward.exception.DetailedException;
import com.moveworkforward.service.OperationListener;
import com.moveworkforward.v2.service.impl.AbstractConfigurationService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitLabConfigurationService
extends AbstractConfigurationService<GitLabConfiguration> {
    public static final String TOKEN_MASK = "********";

    @Autowired
    public GitLabConfigurationService(GitLabRepository pluginRepository, GitLabRecordValidator recordValidator, List<OperationListener> operationListeners) {
        super(pluginRepository, recordValidator, operationListeners);
    }

    @Override
    protected void validate(GitLabConfiguration newConfiguration) {
        if (StringUtils.isBlank((CharSequence)newConfiguration.getUserKey()) && GitLabConfiguration.Level.PERSONAL.equals(newConfiguration.getLevel())) {
            newConfiguration.setUserKey(this.recordValidator.getCurrentUser().getUserKey());
        }
        super.validate(newConfiguration);
        if (CollectionUtils.isNotEmpty(newConfiguration.getAllowedSpaces()) && CollectionUtils.isNotEmpty(newConfiguration.getForbiddenSpaces()) && CollectionUtils.containsAny(newConfiguration.getAllowedSpaces(), newConfiguration.getForbiddenSpaces())) {
            throw new DetailedException("Can not include/exclude the same spaces", "includedSpaceKeys", "excludedSpaceKeys");
        }
        if (TOKEN_MASK.equals(newConfiguration.getApiKey()) && newConfiguration.getId() != null) {
            GitLabConfiguration existingConfiguration = this.pluginRepository.get(newConfiguration.getId(), GitLabConfiguration.class);
            newConfiguration.setApiKey(existingConfiguration.getApiKey());
        }
    }
}

