/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.resources;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabEpic;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.resources.AbstractGitLabResource;
import at.rumpelcoders.confluence.resources.AnnotatedNameValuePair;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.gitlab.api.models.GitlabGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
@Path(value="/groups")
public class EpicsResource
extends AbstractGitLabResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EpicsResource.class);

    @Autowired
    public EpicsResource(ConfigurationManager configurationManager, GitlabApi gitlabApi) {
        super(configurationManager, gitlabApi);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getGroups() {
        try {
            GitlabConnection connection = this.getConnection();
            List<GitlabGroup> groups = this.gitlabApi.getGitlabGroups(connection, Integer.MAX_VALUE, false);
            List resources = groups.stream().map(g2 -> new AnnotatedNameValuePair(g2.getFullName(), g2.getId().intValue())).collect(Collectors.toList());
            GenericEntity<List<AnnotatedNameValuePair>> entity = new GenericEntity<List<AnnotatedNameValuePair>>(resources){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fectching issues from gitlab", (Throwable)e);
            return Response.serverError().status(500).build();
        }
    }

    @GET
    @Path(value="{groupId}/epics")
    @Produces(value={"application/json"})
    public Response getEpics(@PathParam(value="groupId") Integer groupId) {
        try {
            GitlabConnection connection = this.getConnection();
            List<GitlabEpic> groups = this.gitlabApi.getGitlabEpics(connection, groupId);
            List resources = groups.stream().map(g2 -> new AnnotatedNameValuePair(g2.getTitle(), g2.getIid())).collect(Collectors.toList());
            GenericEntity<List<AnnotatedNameValuePair>> entity = new GenericEntity<List<AnnotatedNameValuePair>>(resources){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fectching issues from gitlab", (Throwable)e);
            return Response.serverError().status(500).build();
        }
    }
}

