/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.resources;

import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.service.GitLabConfigurationService;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/config")
@Named(value="configResource")
public class ConfigResource {
    private final GitLabConfigurationService service;
    private final ConfigurationManager configurationManager;

    @Autowired
    public ConfigResource(GitLabConfigurationService service, ConfigurationManager configurationManager) {
        this.service = service;
        this.configurationManager = configurationManager;
    }

    @Path(value="/effective")
    @GET
    @Produces(value={"application/json"})
    public List<GitLabConfiguration> getAll() {
        return this.configurationManager.getPossibleConfigurations().stream().map(this::hideKey).collect(Collectors.toList());
    }

    @GET
    @Produces(value={"application/json"})
    public GitLabConfiguration get(@QueryParam(value="userKey") String userKey) {
        List configurations = StringUtils.isBlank((CharSequence)userKey) ? this.service.getByTag("05f11044-da77-41a8-ac66-a9388ffd0925", GitLabConfiguration.Level.GLOBAL.toString()) : this.service.getByTag(userKey, GitLabConfiguration.Level.PERSONAL.toString());
        GitLabConfiguration result = CollectionUtils.isEmpty(configurations) ? new GitLabConfiguration() : (GitLabConfiguration)configurations.get(0);
        return this.hideKey(result);
    }

    @GET
    @Path(value="checkSpace/{spaceKey}")
    @Produces(value={"application/json"})
    public Response isSpaceAllowed(@PathParam(value="spaceKey") String spaceKey, @Context HttpServletRequest request) {
        GitLabConfiguration configuration = this.configurationManager.getGlobalConfiguration();
        return Response.ok().entity(ImmutableMap.of("spaceKey", spaceKey, "allowed", configuration.isAllowedSpace(spaceKey))).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GitLabConfiguration save(GitLabConfiguration configuration) {
        GitLabConfiguration existingConfiguration;
        if ("********".equals(configuration.getApiKey()) && configuration.getId() != null && configuration.getId() != 0 && (existingConfiguration = (GitLabConfiguration)this.service.get(configuration.getId())) != null) {
            configuration.setApiKey(existingConfiguration.getApiKey());
        }
        GitLabConfiguration result = this.service.save(configuration);
        return this.hideKey(result);
    }

    @DELETE
    @Produces(value={"application/json"})
    public GitLabConfiguration delete(@QueryParam(value="id") Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("ID is null");
        }
        return this.hideKey((GitLabConfiguration)this.service.delete(id));
    }

    public GitLabConfiguration hideKey(GitLabConfiguration configuration) {
        if (configuration != null && StringUtils.isNotBlank((CharSequence)configuration.getApiKey())) {
            configuration = configuration.clone();
            configuration.setApiKey("********");
        }
        return configuration;
    }
}

