/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.resources;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.service.GitLabConfigurationService;
import java.util.HashMap;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.gitlab.api.models.GitlabVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/checkconfig")
@Named(value="checkConfigResource")
public class CheckConfigResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckConfigResource.class);
    private final GitlabApi gitlabApi;
    private final GitLabConfigurationService configurationService;

    @Autowired
    public CheckConfigResource(GitLabConfigurationService configurationService, GitlabApi gitlabApi) {
        this.configurationService = configurationService;
        this.gitlabApi = gitlabApi;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response test(GitLabConfiguration configuration, @Context HttpServletRequest request) {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        Boolean connectionOk = false;
        try {
            GitlabConnection connection;
            GitLabConfiguration existingConfiguration;
            if ("********".equals(configuration.getApiKey()) && configuration.getId() != null && configuration.getId() != 0 && (existingConfiguration = (GitLabConfiguration)this.configurationService.get(configuration.getId())) != null) {
                configuration.setApiKey(existingConfiguration.getApiKey());
            }
            if ((connection = new GitlabConnection.Builder().config(configuration).build()).isValid()) {
                GitlabVersion version = this.gitlabApi.getVersion(connection);
                responseData.put("gitlab_version", version.getVersion());
                connectionOk = true;
            } else {
                log.error("Could not connect to Gitlab API due to invalid configuration");
            }
        }
        catch (Exception e) {
            log.error("Error while checking Gitlab connection", (Throwable)e);
        }
        responseData.put("connectionOk", connectionOk);
        return Response.ok(responseData, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }
}

