/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.model;

import at.rumpelcoders.confluence.ao.converters.GitLabConfigurationConverter;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.validation.LevelPermissionConstraint;
import com.moveworkforward.model.ConfigurationLevel;
import com.moveworkforward.v2.ao.Persistence;
import com.moveworkforward.v2.model.IdModel;
import com.moveworkforward.v2.validation.ValidationGroups;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.gitlab.api.TokenType;

@Persistence(entityType="GITLAB_CONFIGURATION", converter=GitLabConfigurationConverter.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@LevelPermissionConstraint(groups={ValidationGroups.Save.class, ValidationGroups.Get.class})
@JsonAutoDetect
public class GitLabConfiguration
implements IdModel,
Cloneable {
    public static final String TYPE = "GITLAB_CONFIGURATION";
    public static final String ALL_SPACES = "05f11044-da77-41a8-ac66-a9388ffd0925";
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 30;
    private Integer id;
    @NotNull
    private Level level = Level.GLOBAL;
    private String userKey;
    private String apiKey;
    private String serverUrl;
    private TokenType tokenType = TokenType.PRIVATE_TOKEN;
    private GitlabConnection.HostType hostType = GitlabConnection.HostType.SERVER;
    private int requestTimeout = 30;
    private List<String> allowedSpaces = new ArrayList<String>();
    private List<String> forbiddenSpaces = new ArrayList<String>();
    private boolean autoconversionEnabled = true;

    public boolean isAllowedSpace(String spaceKey) {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(this.allowedSpaces) && !this.allowedSpaces.contains(spaceKey)) {
            return false;
        }
        return !CollectionUtils.isNotEmpty(this.forbiddenSpaces) || !this.forbiddenSpaces.contains(spaceKey);
    }

    public GitLabConfiguration clone() {
        return (GitLabConfiguration)super.clone();
    }

    @Generated
    public GitLabConfiguration() {
    }

    @Override
    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Generated
    public String getUserKey() {
        return this.userKey;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Generated
    public TokenType getTokenType() {
        return this.tokenType;
    }

    @Generated
    public GitlabConnection.HostType getHostType() {
        return this.hostType;
    }

    @Generated
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Generated
    public List<String> getAllowedSpaces() {
        return this.allowedSpaces;
    }

    @Generated
    public List<String> getForbiddenSpaces() {
        return this.forbiddenSpaces;
    }

    @Generated
    public boolean isAutoconversionEnabled() {
        return this.autoconversionEnabled;
    }

    @Override
    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setLevel(Level level) {
        this.level = level;
    }

    @Generated
    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Generated
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Generated
    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    @Generated
    public void setHostType(GitlabConnection.HostType hostType) {
        this.hostType = hostType;
    }

    @Generated
    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @Generated
    public void setAllowedSpaces(List<String> allowedSpaces) {
        this.allowedSpaces = allowedSpaces;
    }

    @Generated
    public void setForbiddenSpaces(List<String> forbiddenSpaces) {
        this.forbiddenSpaces = forbiddenSpaces;
    }

    @Generated
    public void setAutoconversionEnabled(boolean autoconversionEnabled) {
        this.autoconversionEnabled = autoconversionEnabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitLabConfiguration)) {
            return false;
        }
        GitLabConfiguration other = (GitLabConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitLabConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GitLabConfiguration(super=" + super.toString() + ", id=" + this.getId() + ", level=" + this.getLevel() + ", userKey=" + this.getUserKey() + ", apiKey=" + this.getApiKey() + ", serverUrl=" + this.getServerUrl() + ", tokenType=" + (Object)((Object)this.getTokenType()) + ", hostType=" + (Object)((Object)this.getHostType()) + ", requestTimeout=" + this.getRequestTimeout() + ", allowedSpaces=" + this.getAllowedSpaces() + ", forbiddenSpaces=" + this.getForbiddenSpaces() + ", autoconversionEnabled=" + this.isAutoconversionEnabled() + ")";
    }

    public static enum Level implements ConfigurationLevel
    {
        PERSONAL,
        GLOBAL;

    }
}

