/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.mermaid;

import at.rumpelcoders.confluence.mermaid.MermaidCodeMacro;
import at.rumpelcoders.confluence.mermaid.MermaidMacroExtension;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.builder.StringSequenceBuilder;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MermaidMacroRenderer
implements NodeRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MermaidMacroRenderer.class);
    private final String macroName;

    public MermaidMacroRenderer(String macroName) {
        this.macroName = macroName;
    }

    @Override
    @Nullable
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<MermaidCodeMacro>(MermaidCodeMacro.class, this::render));
        return set;
    }

    private void render(MermaidCodeMacro node, NodeRendererContext context, HtmlWriter html) {
        StringSequenceBuilder stringSequenceBuilder = StringSequenceBuilder.emptyBuilder();
        stringSequenceBuilder.append("<pre class=\"mermaid\">\n");
        stringSequenceBuilder.append(node.getChars());
        stringSequenceBuilder.append("</pre>\n");
        try {
            html.raw(stringSequenceBuilder.toString());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            html.raw("```mermaid");
            html.raw(node.getChars());
            html.raw("```");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            String macroName = (String)options.getAll().get(MermaidMacroExtension.CONFLUENCE_MERMAID_MACRO);
            if (macroName == null) {
                macroName = MermaidMacroExtension.CONFLUENCE_MERMAID_MACRO.getDefaultValue();
            }
            return new MermaidMacroRenderer(macroName);
        }
    }
}

