/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabBranch;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabJob;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabRelease;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="projectsMacro")
public class ProjectsMacro
extends BaseGitLabMacro {
    public static final String SHOW_DETAILS_PARAMETER = "showDetails";
    public static final String SHOW_BUILD_STATUS_PARAMETER = "showBuildStatus";
    public static final String SHOW_BRANCHES_PARAMETER = "showBranches";
    public static final String SHOW_RELEASES_PARAMETER = "showReleases";
    public static final String PROJECT_PARAMETER = "project";

    @Autowired
    public ProjectsMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider);
    }

    @Override
    public String doExecute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws Exception {
        String projectId = parameters.get(PROJECT_PARAMETER);
        boolean showDetails = true;
        String showDetailsString = parameters.get(SHOW_DETAILS_PARAMETER);
        if (showDetailsString != null) {
            showDetails = Boolean.parseBoolean(showDetailsString);
        }
        boolean showBuildStatus = true;
        String showBuildStatusString = parameters.get(SHOW_BUILD_STATUS_PARAMETER);
        if (showBuildStatusString != null) {
            showBuildStatus = Boolean.parseBoolean(showBuildStatusString);
        }
        boolean showBranches = false;
        String showBranchesString = parameters.get(SHOW_BRANCHES_PARAMETER);
        if (showBranchesString != null) {
            showBranches = Boolean.parseBoolean(showBranchesString);
        }
        boolean showReleases = false;
        String showReleasesString = parameters.get(SHOW_RELEASES_PARAMETER);
        if (showReleasesString != null) {
            showReleases = Boolean.parseBoolean(showReleasesString);
        }
        int groupId = ProjectsMacro.parseInt(parameters.get("group"), -1, "error on parsing group id");
        int count = ProjectsMacro.parseInt(parameters.get("count"), 100, "error on parsing count");
        List<Object> projects = null;
        HashMap<GitlabProject, GitlabJob> builds = new HashMap<GitlabProject, GitlabJob>();
        HashMap<GitlabProject, List<GitlabBranch>> branches = new HashMap<GitlabProject, List<GitlabBranch>>();
        HashMap<GitlabProject, List<GitlabRelease>> releases = new HashMap<GitlabProject, List<GitlabRelease>>();
        GitlabConnection connection = this.getConnection();
        if (StringUtils.isNotBlank((CharSequence)projectId)) {
            projectId = URLDecoder.decode(projectId, StandardCharsets.UTF_8.displayName());
            projects = new ArrayList<GitlabProject>();
            projects.add(this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), true));
        } else {
            List<GitlabProject> list = projects = groupId == -1 ? this.gitlabApi.getProjects(connection, count, true) : this.gitlabApi.getGroupProjects(connection, groupId, count);
        }
        if (showBuildStatus) {
            for (GitlabProject gitlabProject : projects) {
                List<GitlabJob> buildList = this.gitlabApi.getBuilds(connection, gitlabProject.getId(), 1);
                if (buildList.isEmpty()) continue;
                builds.put(gitlabProject, buildList.get(0));
            }
        }
        if (showBranches) {
            for (GitlabProject gitlabProject : projects) {
                List<GitlabBranch> branchesList = this.gitlabApi.getBranches(connection, gitlabProject.getId());
                if (branchesList.isEmpty()) continue;
                branches.put(gitlabProject, branchesList);
            }
        }
        if (showReleases) {
            for (GitlabProject gitlabProject : projects) {
                List<GitlabRelease> releasesList = this.gitlabApi.getReleases(connection, gitlabProject.getId());
                if (releasesList.isEmpty()) continue;
                releases.put(gitlabProject, releasesList);
            }
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("projects", projects);
        context.put("detail", showDetails);
        context.put("builds", builds);
        context.put("branches", branches);
        context.put("releases", releases);
        return VelocityUtils.getRenderedTemplate((String)"templates/projects-macro.vm", (Map)context);
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.projectsmacro.error");
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

