/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import lombok.Generated;
import org.gitlab.api.models.GitlabGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="groupsMacro")
public class GroupsMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupsMacro.class);
    public static final String SHOW_ONLY_DIRECT_GROUPS = "showOnlyDirectGroups";

    @Autowired
    public GroupsMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider);
    }

    @Override
    public String doExecute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws Exception {
        boolean showOnlyDirectGroups = true;
        String showOnlyDirectGroupsString = parameters.get(SHOW_ONLY_DIRECT_GROUPS);
        if (showOnlyDirectGroupsString != null) {
            showOnlyDirectGroups = Boolean.parseBoolean(showOnlyDirectGroupsString);
        }
        Integer groupId = GroupsMacro.parseInt(parameters.get("group"), -1, "error on parsing group id");
        int count = GroupsMacro.parseInt(parameters.get("count"), 100, "error on parsing count");
        List<GitlabGroup> groups = null;
        GitlabConnection connection = this.getConnection();
        groups = !groupId.equals(-1) ? this.gitlabApi.getGitlabSubGroups(connection, groupId, count, showOnlyDirectGroups) : this.gitlabApi.getGitlabGroups(connection, count, showOnlyDirectGroups);
        Map context = MacroUtils.defaultVelocityContext();
        context.put("groups", groups);
        return VelocityUtils.getRenderedTemplate((String)"templates/groups-macro.vm", (Map)context);
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.groupsmacro.error");
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

