/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabCommit;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabCommitDiff;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="commitMacro")
public class CommitMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommitMacro.class);
    private static final String COMMIT_HASH_PARAMETER = "commitHash";
    private static final String SHOW_DIFF_PARAMETER = "showDiff";

    @Autowired
    public CommitMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider);
    }

    @Override
    protected String doExecute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws Exception {
        String projectId = URLDecoder.decode(parameters.get("project"), StandardCharsets.UTF_8.displayName());
        String commitHash = parameters.get(COMMIT_HASH_PARAMETER);
        if (StringUtils.isBlank((CharSequence)commitHash)) {
            return "Please provide a valid commit hash";
        }
        boolean showDiff = false;
        String showDiffString = parameters.get(SHOW_DIFF_PARAMETER);
        if (showDiffString != null) {
            showDiff = Boolean.parseBoolean(showDiffString);
        }
        GitlabProject project = null;
        GitlabCommit commit = null;
        ArrayList<GitlabCommitDiff> commitDiffs = new ArrayList();
        GitlabConnection connection = this.getConnection();
        try {
            project = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
            commit = this.gitlabApi.getCommit(connection, project.getId(), commitHash);
            if (showDiff) {
                commitDiffs = this.gitlabApi.getCommitDiff(connection, project.getId(), commitHash);
            }
        }
        catch (Exception e) {
            log.error(String.format("error on fetching builds for key %s", projectId), (Throwable)e);
            throw e;
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("gitLabUrl", connection.getUrl());
        context.put("project", project);
        context.put("commit", commit);
        this.collectDiffFiles(context, commitDiffs, "addedFiles", GitlabCommitDiff::isNewFile);
        this.collectDiffFiles(context, commitDiffs, "deletedFiles", GitlabCommitDiff::isDeletedFile);
        this.collectDiffFiles(context, commitDiffs, "renamedFiles", GitlabCommitDiff::isRenamedFile);
        this.collectDiffFiles(context, commitDiffs, "modifiedFiles", diff -> !diff.isDeletedFile() && !diff.isRenamedFile() && !diff.isNewFile());
        return VelocityUtils.getRenderedTemplate((String)"templates/commit-macro.vm", (Map)context);
    }

    private void collectDiffFiles(Map<String, Object> context, List<GitlabCommitDiff> commitDiffs, String name, Function<GitlabCommitDiff, Boolean> filter) {
        List files = commitDiffs.stream().filter(filter::apply).collect(Collectors.toList());
        if (!files.isEmpty()) {
            context.put(name, files);
        }
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.commitmacro.error");
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

