/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.FileNotFoundException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.gitlab.api.GitlabAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGitLabMacro
implements Macro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseGitLabMacro.class);
    public static final String COUNT = "count";
    public static final String TEMPLATES_INVALID_LICENSE = "templates/invalid-license.vm";
    protected GitlabApi gitlabApi;
    protected ConfigurationManager configurationManager;
    protected LicenseManager licenseManager;
    protected I18nResolver i18nResolver;
    protected WebResourceUrlProvider webResourceUrlProvider;

    public BaseGitLabMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        this.gitlabApi = gitlabApi;
        this.configurationManager = configurationManager;
        this.licenseManager = licenseManager;
        this.i18nResolver = i18nResolver;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    public static int parseInt(String value, int defaultValue, String errorMessage) {
        try {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception e) {
            log.error(errorMessage, (Throwable)e);
        }
        return defaultValue;
    }

    protected boolean getParameter(Map<String, String> parameters, String name, boolean defaultValue) {
        boolean result = defaultValue;
        String showReleasesString = parameters.get(name);
        if (showReleasesString != null) {
            result = Boolean.parseBoolean(showReleasesString);
        }
        return result;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.hasValidLicense()) {
            return this.getLicensingErrorString();
        }
        GitLabConfiguration configuration = this.configurationManager.getGlobalConfiguration();
        if (!configuration.isAllowedSpace(conversionContext.getSpaceKey())) {
            Map context = MacroUtils.defaultVelocityContext();
            return VelocityUtils.getRenderedTemplate((String)"templates/not-allowed-space.vm", (Map)context);
        }
        GitlabConnection connection = this.getConnection();
        if (!connection.isValid()) {
            return this.handleError("", true, parameters);
        }
        try {
            return this.doExecute(parameters, bodyContent, conversionContext);
        }
        catch (GitLabApiException apiException) {
            return this.handleError(this.getErrorMessageFromException(apiException), parameters);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.handleError(this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.unexpected.error"), parameters);
        }
    }

    protected abstract String doExecute(Map<String, String> var1, String var2, ConversionContext var3) throws Exception;

    protected boolean hasValidLicense() {
        return this.licenseManager.isLicensed();
    }

    protected String getLicensingErrorString() {
        Map context = MacroUtils.defaultVelocityContext();
        return VelocityUtils.getRenderedTemplate((String)TEMPLATES_INVALID_LICENSE, (Map)context);
    }

    protected GitlabConnection getConnection() {
        GitLabConfiguration configuration = this.configurationManager.getSuitableConfiguration();
        return new GitlabConnection.Builder().config(configuration).build();
    }

    protected String getErrorMessageFromException(GitLabApiException apiException) {
        String errorText;
        log.error(apiException.getMessage(), (Throwable)apiException);
        try {
            if (apiException.getCause() instanceof FileNotFoundException) {
                return "Resource is not found";
            }
            if (apiException.getCause() instanceof GitlabAPIException) {
                JSONObject jsonObject = new JSONObject(apiException.getCause().getMessage());
                errorText = (String)jsonObject.get("message");
            } else {
                errorText = apiException.getMessage();
            }
        }
        catch (Exception e) {
            errorText = apiException.getMessage();
        }
        return errorText;
    }

    protected String handleError(String errorText, Map<String, String> parameters) {
        return this.handleError(errorText, false, parameters);
    }

    protected String handleError(String errorText, boolean setupError, Map<String, String> parameters) {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("errorMacroPrefix", this.getMacroErrorPrefix());
        context.put("errorText", errorText);
        context.put("setupError", setupError);
        context.put("baseUrl", this.getBaseUrl());
        String defaultResult = VelocityUtils.getRenderedTemplate((String)"templates/error.vm", (Map)context);
        String link = parameters.get("link");
        if (StringUtils.isBlank((CharSequence)link)) {
            return defaultResult;
        }
        if (!new UrlValidator(8L).isValid(link = URLDecoder.decode(link, StandardCharsets.UTF_8.displayName()))) {
            return defaultResult;
        }
        return String.format("<a href=\"%s\">%s</a>", link, link) + defaultResult;
    }

    protected abstract String getMacroErrorPrefix();

    public String getBaseUrl() {
        return this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
    }
}

