/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.components;

import at.rumpelcoders.confluence.ao.GitLabRepository;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationManager.class);
    private final GitLabRepository pluginRepository;

    @Autowired
    public ConfigurationManager(GitLabRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
    }

    public GitLabConfiguration getGlobalConfiguration() {
        List<GitLabConfiguration> configurations = this.pluginRepository.getByTag("05f11044-da77-41a8-ac66-a9388ffd0925", GitLabConfiguration.class);
        return CollectionUtils.isEmpty(configurations) ? new GitLabConfiguration() : configurations.get(0);
    }

    public GitLabConfiguration getPersonalConfiguration(String userKey) {
        List<GitLabConfiguration> configurations = this.pluginRepository.getByTag(userKey, GitLabConfiguration.class);
        return CollectionUtils.isEmpty(configurations) ? new GitLabConfiguration() : configurations.get(0);
    }

    public List<GitLabConfiguration> getPossibleConfigurations() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        ArrayList<GitLabConfiguration> configurations = new ArrayList<GitLabConfiguration>();
        configurations.addAll(this.pluginRepository.getByTag(confluenceUser.getKey().getStringValue(), GitLabConfiguration.class));
        configurations.addAll(this.pluginRepository.getByTag("05f11044-da77-41a8-ac66-a9388ffd0925", GitLabConfiguration.class));
        return configurations;
    }

    public GitLabConfiguration getSuitableConfiguration() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        List<GitLabConfiguration> configurations = this.pluginRepository.getByTag(confluenceUser.getKey().getStringValue(), GitLabConfiguration.class);
        if (CollectionUtils.isEmpty(configurations)) {
            log.debug("Personal configuration is not found, using global one");
            configurations = this.pluginRepository.getByTag("05f11044-da77-41a8-ac66-a9388ffd0925", GitLabConfiguration.class);
        }
        return CollectionUtils.isEmpty(configurations) ? new GitLabConfiguration() : configurations.get(0);
    }
}

