/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.beans.apiwrapper;

import at.rumpelcoders.confluence.beans.apiwrapper.GitlabUser;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;

public class GitlabProject {
    private Integer id;
    private String name;
    private String nameWithNamespace;
    private String description;
    private String defaultBranch;
    private GitlabUser owner;
    private Boolean publicProject;
    private String path;
    private String visibility;
    private String pathWithNamespace;
    private Boolean issuesEnabled;
    private Boolean mergeRequestsEnabled;
    private Boolean snippetsEnabled;
    private Date createdAt;
    private String sshUrl;
    private String webUrl;
    private String httpUrl;
    private Date lastActivityAt;
    private Boolean archived;
    private String avatarUrl;
    private Integer creatorId;
    private Integer starCount;
    private Integer forksCount;
    private List<String> tagList;
    private GitlabProject forkedFrom;

    public GitlabProject(org.gitlab.api.models.GitlabProject project) {
        this.id = project.getId();
        this.name = project.getName();
        this.nameWithNamespace = project.getNameWithNamespace();
        this.description = project.getDescription();
        this.defaultBranch = project.getDefaultBranch();
        this.owner = project.getOwner() != null ? new GitlabUser(project.getOwner()) : null;
        this.publicProject = project.isPublic();
        this.path = project.getPath();
        this.pathWithNamespace = project.getPathWithNamespace();
        this.issuesEnabled = project.isIssuesEnabled();
        this.mergeRequestsEnabled = project.isMergeRequestsEnabled();
        this.snippetsEnabled = project.isSnippetsEnabled();
        this.createdAt = project.getCreatedAt();
        this.sshUrl = project.getSshUrl();
        this.webUrl = project.getWebUrl();
        this.httpUrl = project.getHttpUrl();
        this.lastActivityAt = project.getLastActivityAt();
        this.archived = project.isArchived();
        this.avatarUrl = project.getAvatarUrl();
        this.creatorId = project.getCreatorId();
        this.starCount = project.getStarCount();
        this.forksCount = project.getForksCount();
        this.tagList = project.getTagList() != null ? project.getTagList() : new ArrayList<String>();
        this.forkedFrom = project.getForkedFrom() != null ? new GitlabProject(project.getForkedFrom()) : null;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameWithNamespace() {
        return this.nameWithNamespace;
    }

    public void setNameWithNamespace(String nameWithNamespace) {
        this.nameWithNamespace = nameWithNamespace;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public GitlabUser getOwner() {
        return this.owner;
    }

    public void setOwner(GitlabUser owner) {
        this.owner = owner;
    }

    public Boolean getPublicProject() {
        return this.publicProject;
    }

    public void setPublicProject(Boolean publicProject) {
        this.publicProject = publicProject;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getPathWithNamespace() {
        return this.pathWithNamespace;
    }

    public void setPathWithNamespace(String pathWithNamespace) {
        this.pathWithNamespace = pathWithNamespace;
    }

    public Boolean getIssuesEnabled() {
        return this.issuesEnabled;
    }

    public void setIssuesEnabled(Boolean issuesEnabled) {
        this.issuesEnabled = issuesEnabled;
    }

    public Boolean getMergeRequestsEnabled() {
        return this.mergeRequestsEnabled;
    }

    public void setMergeRequestsEnabled(Boolean mergeRequestsEnabled) {
        this.mergeRequestsEnabled = mergeRequestsEnabled;
    }

    public Boolean getSnippetsEnabled() {
        return this.snippetsEnabled;
    }

    public void setSnippetsEnabled(Boolean snippetsEnabled) {
        this.snippetsEnabled = snippetsEnabled;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getSshUrl() {
        return this.sshUrl;
    }

    public void setSshUrl(String sshUrl) {
        this.sshUrl = sshUrl;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public Date getLastActivityAt() {
        return this.lastActivityAt;
    }

    public void setLastActivityAt(Date lastActivityAt) {
        this.lastActivityAt = lastActivityAt;
    }

    public Boolean getArchived() {
        return this.archived;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public Integer getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Integer creatorId) {
        this.creatorId = creatorId;
    }

    public Integer getStarCount() {
        return this.starCount;
    }

    public void setStarCount(Integer starCount) {
        this.starCount = starCount;
    }

    public Integer getForksCount() {
        return this.forksCount;
    }

    public void setForksCount(Integer forksCount) {
        this.forksCount = forksCount;
    }

    public List<String> getTagList() {
        return this.tagList;
    }

    public void setTagList(List<String> tagList) {
        this.tagList = tagList;
    }

    public GitlabProject getForkedFrom() {
        return this.forkedFrom;
    }

    public void setForkedFrom(GitlabProject forkedFrom) {
        this.forkedFrom = forkedFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitlabProject that = (GitlabProject)o;
        if (this.id != null || that.id != null) {
            return this.id != null && this.id.equals(that.id);
        }
        return false;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    @Generated
    public GitlabProject() {
    }
}

