/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.beans;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class IssueFilterBuilder {
    public static final int MAX_ENTRIES = 300;
    public static final int DEFAULT_ENTRIES = 100;
    private int maximumEntries;
    private String label;
    private String state;
    private String orderBy;
    private String sort;

    public IssueFilterBuilder(int maximumEntries) {
        this.maximumEntries = maximumEntries;
    }

    public IssueFilterBuilder() {
        this.label = null;
        this.orderBy = null;
        this.state = null;
        this.sort = null;
        this.maximumEntries = 100;
    }

    public IssueFilterBuilder setLabel(String label) {
        if (label != null && !label.replaceAll("\\s+", "").isEmpty()) {
            this.label = label;
        }
        return this;
    }

    public IssueFilterBuilder setState(String state) {
        this.state = state;
        return this;
    }

    public IssueFilterBuilder setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public IssueFilterBuilder setSort(String sort) {
        this.sort = sort;
        return this;
    }

    public IssueFilterBuilder setMaximumEntries(int maximumEntries) {
        if (maximumEntries > 0 && maximumEntries < 300) {
            this.maximumEntries = maximumEntries;
        }
        return this;
    }

    public int getMaximumEntries() {
        return this.maximumEntries;
    }

    public StringBuilder build(String baseQuery, int page) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.label != null && !this.label.trim().isEmpty()) {
            parameters.put("labels", URLEncoder.encode(this.label.trim(), StandardCharsets.UTF_8.displayName()));
        }
        if (this.state != null && !this.state.trim().isEmpty()) {
            parameters.put("state", URLEncoder.encode(this.state.trim(), StandardCharsets.UTF_8.displayName()));
        }
        if (this.orderBy != null && !this.orderBy.trim().isEmpty()) {
            this.orderBy = this.orderBy.trim().equals("UpdatedAt") ? "updated_at" : "created_at";
            parameters.put("order_by", this.orderBy);
        }
        if (this.sort != null && !this.sort.trim().isEmpty()) {
            this.sort = this.sort.trim().equals("Ascending") ? "asc" : "desc";
            parameters.put("sort", this.sort);
        }
        int entriesPerPage = this.maximumEntries > 0 && this.maximumEntries < 100 ? this.maximumEntries : 100;
        parameters.put("per_page", String.format("%s", entriesPerPage));
        parameters.put("page", String.format("%s", page));
        StringBuilder tailUrl = new StringBuilder(baseQuery);
        boolean first = true;
        for (String key : parameters.keySet()) {
            String value = (String)parameters.get(key);
            String separator = "&";
            if (first) {
                separator = "?";
                first = false;
            }
            tailUrl.append(String.format("%s%s=%s", separator, key, value));
        }
        return tailUrl;
    }
}

