/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.ao.migration;

import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.moveworkforward.ao.entity.PluginSettingEntity;
import com.moveworkforward.v2.ao.impl.AbstractPluginRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gitlab.api.TokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpgradeTask2
implements ActiveObjectsUpgradeTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask2.class);
    public static final String PREVIOUS_CLASS_NAME = "at.rumpelcoders.confluence.resources.ConfigResource$Config";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public UpgradeTask2(@ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport TransactionTemplate transactionTemplate) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
    }

    public static Config getSettings(PluginSettingsFactory pluginSettingsFactory) {
        String tokenType;
        String serverUrl;
        PluginSettings settings = pluginSettingsFactory.createGlobalSettings();
        Config config = new Config();
        String apiKey = (String)settings.get("at.rumpelcoders.confluence.resources.ConfigResource$Config.apikey");
        if (apiKey != null) {
            config.setApiKey(apiKey);
        }
        if ((serverUrl = (String)settings.get("at.rumpelcoders.confluence.resources.ConfigResource$Config.serverurl")) != null) {
            config.setServerUrl(serverUrl);
        }
        config.setTokenType(StringUtils.isBlank((CharSequence)(tokenType = (String)settings.get("at.rumpelcoders.confluence.resources.ConfigResource$Config.tokentype"))) ? TokenType.PRIVATE_TOKEN : TokenType.valueOf(tokenType));
        String hostType = (String)settings.get("at.rumpelcoders.confluence.resources.ConfigResource$Config.hosttype");
        config.setHostType(StringUtils.isBlank((CharSequence)hostType) ? GitlabConnection.HostType.SERVER : GitlabConnection.HostType.valueOf(hostType));
        String requestTimeout = (String)settings.get("at.rumpelcoders.confluence.resources.ConfigResource$Config.requesttimeout");
        if (StringUtils.isNotBlank((CharSequence)requestTimeout)) {
            try {
                config.setRequestTimeout(Integer.parseInt(requestTimeout));
            }
            catch (Exception e) {
                config.setRequestTimeout(30);
            }
        } else {
            config.setRequestTimeout(30);
        }
        List<String> allowedSpaces = UpgradeTask2.getListSetting(settings, "allowedSpaces");
        config.setAllowedSpaces(allowedSpaces);
        List<String> forbiddenSpaces = UpgradeTask2.getListSetting(settings, "forbiddenSpaces");
        config.setForbiddenSpaces(forbiddenSpaces);
        return config;
    }

    private static List<String> getListSetting(PluginSettings settings, String key) {
        ArrayList<String> result = new ArrayList<String>();
        String setting = (String)settings.get("at.rumpelcoders.confluence.resources.ConfigResource$Config." + key);
        if (StringUtils.isNotBlank((CharSequence)setting)) {
            result.addAll(Arrays.stream(setting.split(",")).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toSet()));
        }
        return result;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        log.info("Migrating to AO layer");
        try {
            activeObjects.migrate(new Class[]{PluginSettingEntity.class});
        }
        catch (Throwable t2) {
            log.error("Error migrating AO tables:: ", t2);
        }
        Config oldConfig = UpgradeTask2.getSettings(this.pluginSettingsFactory);
        if (StringUtils.isBlank((CharSequence)oldConfig.getApiKey()) && StringUtils.isBlank((CharSequence)oldConfig.getServerUrl()) && CollectionUtils.isEmpty(oldConfig.getAllowedSpaces()) && CollectionUtils.isEmpty(oldConfig.getForbiddenSpaces())) {
            log.info("Nothing to migrate");
            return;
        }
        AbstractPluginRepository<PluginSettingEntity> repository = new AbstractPluginRepository<PluginSettingEntity>(activeObjects, this.transactionTemplate){};
        GitLabConfiguration configuration = new GitLabConfiguration();
        configuration.setApiKey(oldConfig.getApiKey());
        configuration.setServerUrl(oldConfig.getServerUrl());
        configuration.setHostType(oldConfig.getHostType());
        configuration.setTokenType(oldConfig.getTokenType());
        configuration.setRequestTimeout(oldConfig.getRequestTimeout());
        configuration.setAllowedSpaces(oldConfig.getAllowedSpaces());
        configuration.setForbiddenSpaces(oldConfig.getForbiddenSpaces());
        try {
            repository.save(configuration);
            log.info("Migration to new DB schema has finished");
        }
        catch (Exception e) {
            log.error("Migration failed", (Throwable)e);
        }
    }

    public static class Config {
        public static final String FIELD_APIKEY = "apikey";
        public static final String FIELD_SERVERURL = "serverurl";
        public static final String FIELD_TOKEN_TYPE = "tokentype";
        public static final String FIELD_HOST_TYPE = "hosttype";
        public static final String FIELD_REQUEST_TIMEOUTE = "requesttimeout";
        public static final String ALLOWED_SPACES = "allowedSpaces";
        public static final String FORBIDDEN_SPACES = "forbiddenSpaces";
        private String apiKey;
        private String serverUrl;
        private TokenType tokenType = TokenType.PRIVATE_TOKEN;
        private GitlabConnection.HostType hostType = GitlabConnection.HostType.SERVER;
        private int requestTimeout = 30;
        private List<String> allowedSpaces = new ArrayList<String>();
        private List<String> forbiddenSpaces = new ArrayList<String>();

        @Generated
        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Generated
        public void setServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        @Generated
        public void setTokenType(TokenType tokenType) {
            this.tokenType = tokenType;
        }

        @Generated
        public void setHostType(GitlabConnection.HostType hostType) {
            this.hostType = hostType;
        }

        @Generated
        public void setRequestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout;
        }

        @Generated
        public void setAllowedSpaces(List<String> allowedSpaces) {
            this.allowedSpaces = allowedSpaces;
        }

        @Generated
        public void setForbiddenSpaces(List<String> forbiddenSpaces) {
            this.forbiddenSpaces = forbiddenSpaces;
        }

        @Generated
        public String getApiKey() {
            return this.apiKey;
        }

        @Generated
        public String getServerUrl() {
            return this.serverUrl;
        }

        @Generated
        public TokenType getTokenType() {
            return this.tokenType;
        }

        @Generated
        public GitlabConnection.HostType getHostType() {
            return this.hostType;
        }

        @Generated
        public int getRequestTimeout() {
            return this.requestTimeout;
        }

        @Generated
        public List<String> getAllowedSpaces() {
            return this.allowedSpaces;
        }

        @Generated
        public List<String> getForbiddenSpaces() {
            return this.forbiddenSpaces;
        }
    }
}

