/*
 * Decompiled with CFR 0.152.
 */
package com.figma.api.dto;

import com.figma.api.dto.BooleanOperation;
import com.figma.api.dto.Canvas;
import com.figma.api.dto.Document;
import com.figma.api.dto.Frame;
import com.figma.api.dto.Instance;
import com.figma.api.dto.Node;
import com.figma.api.dto.NodeType;
import com.figma.api.dto.Rectangle;
import com.figma.api.dto.Slice;
import com.figma.api.dto.Text;
import com.figma.api.dto.Vector;
import java.io.IOException;
import java.util.ArrayList;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;

public class NodeDeserializer
extends JsonDeserializer<Node[]> {
    public Node[] deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = jp.getCodec();
        JsonNode node = codec.readTree(jp);
        if (node.isArray()) {
            ArrayList<Node> result = new ArrayList<Node>();
            for (JsonNode child : node) {
                result.add(this.toNode(child, codec));
            }
            return result.toArray(new Node[0]);
        }
        throw new JsonMappingException("Element is not an array", jp.getCurrentLocation());
    }

    private Node toNode(JsonNode node, ObjectCodec codec) throws IOException {
        NodeType nodeType;
        String type = node.get("type").asText();
        try {
            nodeType = NodeType.valueOf(type);
        }
        catch (IllegalArgumentException exp) {
            throw JsonMappingException.wrapWithPath((Throwable)exp, (Object)node, (String)type);
        }
        switch (nodeType) {
            case DOCUMENT: {
                return (Node)codec.treeToValue(node, Document.class);
            }
            case CANVAS: {
                return (Node)codec.treeToValue(node, Canvas.class);
            }
            case FRAME: 
            case GROUP: 
            case COMPONENT: 
            case COMPONENT_SET: {
                return (Node)codec.treeToValue(node, Frame.class);
            }
            case VECTOR: 
            case STAR: 
            case LINE: 
            case ELLIPSE: 
            case REGULAR_POLYGON: {
                return (Node)codec.treeToValue(node, Vector.class);
            }
            case BOOLEAN: 
            case BOOLEAN_OPERATION: {
                return (Node)codec.treeToValue(node, BooleanOperation.class);
            }
            case RECTANGLE: {
                return (Node)codec.treeToValue(node, Rectangle.class);
            }
            case TEXT: {
                return (Node)codec.treeToValue(node, Text.class);
            }
            case SLICE: {
                return (Node)codec.treeToValue(node, Slice.class);
            }
            case INSTANCE: {
                return (Node)codec.treeToValue(node, Instance.class);
            }
            case STICKY: 
            case SHAPE_WITH_TEXT: 
            case CONNECTOR: {
                return (Node)codec.treeToValue(node, Node.class);
            }
        }
        throw JsonMappingException.wrapWithPath((Throwable)new IOException("Invalid value for the \"type\" property: " + nodeType), (Object)node, (String)type);
    }
}

