/*
 * Decompiled with CFR 0.152.
 */
package com.figma.api.dto;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class FileRequest {
    private String version;
    private String nodeId;
    private List<String> ids;
    private Integer depth;
    private String geometry;
    private boolean branchData;

    FileRequest(String version, String nodeId, List<String> ids, Integer depth, String geometry, boolean branchData) {
        this.version = version;
        this.nodeId = nodeId;
        this.ids = ids;
        this.depth = depth;
        this.geometry = geometry;
        this.branchData = branchData;
    }

    public static FileRequestBuilder builder() {
        return new FileRequestBuilder();
    }

    public String getVersion() {
        return this.version;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public String getGeometry() {
        return this.geometry;
    }

    public boolean isBranchData() {
        return this.branchData;
    }

    public static class FileRequestBuilder {
        private String version;
        private String nodeId;
        private List<String> ids;
        private Integer depth;
        private String geometry;
        private boolean branchData;

        FileRequestBuilder() {
        }

        public FileRequestBuilder version(String version) {
            this.version = version;
            return this;
        }

        public FileRequestBuilder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public FileRequestBuilder ids(List<String> ids) {
            this.ids = ids;
            return this;
        }

        public FileRequestBuilder depth(Integer depth) {
            this.depth = depth;
            return this;
        }

        public FileRequestBuilder geometry(String geometry) {
            this.geometry = geometry;
            return this;
        }

        public FileRequestBuilder branchData(boolean branchData) {
            this.branchData = branchData;
            return this;
        }

        public FileRequest build() {
            return new FileRequest(this.version, this.nodeId, this.ids, this.depth, this.geometry, this.branchData);
        }

        public String toString() {
            return "FileRequest.FileRequestBuilder(version=" + this.version + ", nodeId=" + this.nodeId + ", ids=" + this.ids + ", depth=" + this.depth + ", geometry=" + this.geometry + ", branchData=" + this.branchData + ")";
        }
    }
}

