/*
 * Decompiled with CFR 0.152.
 */
package com.figma.api;

import com.figma.api.dto.File;
import com.figma.api.dto.FileRequest;
import com.figma.api.dto.Images;
import com.figma.api.dto.ImagesRequest;
import com.figma.api.dto.User;
import com.figma.api.dto.Version;
import com.figma.api.dto.Versions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;

public class FigmaAPI {
    private final HttpClient client;

    public FigmaAPI(String token) {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        if (null != token) {
            headers.add(new BasicHeader("X-FIGMA-TOKEN", token));
        }
        this.client = HttpClientBuilder.create().setDefaultHeaders(headers).useSystemProperties().build();
    }

    @Nonnull
    public User getUser() throws URISyntaxException, IOException {
        return this.fetch(User.class, new URIBuilder(this.getUrl("/me")));
    }

    @Nullable
    public Version getLatestVersion(String key) throws URISyntaxException, IOException {
        List<Version> versions = this.getVersions(key, null, null, "1");
        return versions.stream().findFirst().orElse(null);
    }

    @Nullable
    public Version getVersion(String id, String key) throws URISyntaxException, IOException {
        List<Version> versionsBefore = this.getVersions(key, null, id, "1");
        Version versionBefore = versionsBefore.stream().findFirst().orElse(null);
        if (null == versionBefore) {
            Version latestVersion = this.getLatestVersion(key);
            if (latestVersion != null && latestVersion.getId().equals(id)) {
                return latestVersion;
            }
        } else {
            List<Version> versionsAfter = this.getVersions(key, versionBefore.getId(), null, "2");
            return versionsAfter.stream().filter(item -> item.getId().equals(id)).findFirst().orElse(null);
        }
        return null;
    }

    public List<Version> getVersions(String key, String after, String before, String limit) throws URISyntaxException, IOException {
        URIBuilder uri = new URIBuilder(this.getUrl(String.format("/files/%s/versions", key)));
        uri.addParameter("page_size", limit != null && !limit.isEmpty() ? limit : "30");
        if (null != after) {
            uri.addParameter("after", after);
        }
        if (null != before) {
            uri.addParameter("before", before);
        }
        Versions versions = this.fetch(Versions.class, uri);
        return versions.getVersions();
    }

    public File getFile(String key) throws URISyntaxException, IOException {
        return this.getFile(key, FileRequest.builder().build());
    }

    public File getFile(String key, FileRequest options) throws URISyntaxException, IOException {
        URIBuilder uri = new URIBuilder(this.getUrl(String.format("/files/%s", key)));
        if (options.getVersion() != null) {
            uri.addParameter("version", options.getVersion());
        }
        if (options.getDepth() != null) {
            uri.addParameter("depth", String.valueOf(options.getDepth()));
        }
        if (options.getGeometry() != null) {
            uri.addParameter("geometry", options.getGeometry());
        }
        if (options.getNodeId() != null && !options.getNodeId().isEmpty()) {
            uri.addParameter("ids", options.getNodeId());
        }
        if (options.getIds() != null && !options.getIds().isEmpty()) {
            uri.addParameter("ids", String.join((CharSequence)",", options.getIds()));
        }
        return this.fetch(File.class, uri);
    }

    public Images getImage(String key) throws URISyntaxException, IOException {
        return this.getImage(key, ImagesRequest.builder().build());
    }

    public Images getImage(String key, ImagesRequest options) throws URISyntaxException, IOException {
        URIBuilder uri = new URIBuilder(this.getUrl(String.format("/images/%s", key)));
        if ((options.getNodeId() == null || options.getNodeId().isEmpty()) && (options.getIds() == null || options.getIds().isEmpty())) {
            throw new IllegalArgumentException("Parameter 'ids' is required");
        }
        if (options.getNodeId() != null && !options.getNodeId().isEmpty()) {
            uri.addParameter("ids", options.getNodeId());
        }
        if (options.getIds() != null && !options.getIds().isEmpty()) {
            uri.addParameter("ids", String.join((CharSequence)",", options.getIds()));
        }
        if (options.getScale() != null) {
            uri.addParameter("scale", String.valueOf(options.getScale()));
        }
        if (options.getFormat() != null) {
            uri.addParameter("format", options.getFormat().name());
        }
        if (options.getSvg_include_id() != null && options.getSvg_include_id().booleanValue()) {
            uri.addParameter("svg_include_id", "true");
        }
        if (options.getSvg_simplify_stroke() != null && !options.getSvg_simplify_stroke().booleanValue()) {
            uri.addParameter("svg_simplify_stroke", "false");
        }
        if (options.getUse_absolute_bounds() != null && options.getUse_absolute_bounds().booleanValue()) {
            uri.addParameter("use_absolute_bounds", "true");
        }
        if (options.getVersion() != null) {
            uri.addParameter("version", options.getVersion());
        }
        return this.fetch(Images.class, uri);
    }

    private <T> T fetch(Class<T> type, URIBuilder uri) throws URISyntaxException, IOException {
        HttpResponse response = this.client.execute((HttpUriRequest)new HttpGet(uri.build()));
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            InputStream stream = response.getEntity().getContent();
            String content = this.streamToString(stream);
            return (T)new ObjectMapper().configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(content, type);
        }
        if (statusCode == 400) {
            throw new IOException("400 Bad Request: Parameters are invalid or malformed. Please check the input formats.");
        }
        if (statusCode == 404) {
            throw new IOException("404 Not found: The requested file or resource was not found.");
        }
        if (statusCode == 429) {
            throw new IOException("429 Rate limit: In some cases API requests may be throttled or rate limited. Please wait a while before attempting the request again (typically a minute).");
        }
        if (statusCode == 500) {
            throw new IOException("500 Internal server error: This most commonly occurs for very large image render requests, which may time out our server and return a 500. Please reduce the number and size of objects requested.");
        }
        throw new IOException(String.format("%s: an unknown error occurred", statusCode));
    }

    private String streamToString(InputStream stream) throws IOException {
        String str;
        InputStreamReader isReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(isReader);
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            sb.append(str);
        }
        return sb.toString();
    }

    private String getUrl(String path) {
        Object pathWithPrefix = path.startsWith("/") ? path : "/" + path;
        return String.format("%s%s", "https://api.figma.com/v1", pathWithPrefix);
    }
}

