/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class CacheKey<T extends Serializable>
implements Serializable {
    private final T method;
    private final Map<String, String> keys;
    private final Map<String, String> parameters;

    public Map<String, String> getParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.keys);
        result.putAll(this.parameters);
        return result;
    }

    public String toString() {
        return this.keys.entrySet().stream().map(entity -> (String)entity.getKey() + ":" + (String)entity.getValue()).collect(Collectors.joining(";"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        return Objects.equals(this.keys, cacheKey.keys);
    }

    public int hashCode() {
        return Objects.hash(this.keys);
    }

    CacheKey(T method, Map<String, String> keys, Map<String, String> parameters) {
        this.method = method;
        this.keys = keys;
        this.parameters = parameters;
    }

    public static <T extends Serializable> CacheKeyBuilder<T> builder() {
        return new CacheKeyBuilder();
    }

    public T getMethod() {
        return this.method;
    }

    public static class CacheKeyBuilder<T extends Serializable> {
        private T method;
        private ArrayList<String> keys$key;
        private ArrayList<String> keys$value;
        private ArrayList<String> parameters$key;
        private ArrayList<String> parameters$value;

        CacheKeyBuilder() {
        }

        public CacheKeyBuilder<T> method(T method) {
            this.method = method;
            return this;
        }

        public CacheKeyBuilder<T> key(String keyKey, String keyValue) {
            if (this.keys$key == null) {
                this.keys$key = new ArrayList();
                this.keys$value = new ArrayList();
            }
            this.keys$key.add(keyKey);
            this.keys$value.add(keyValue);
            return this;
        }

        public CacheKeyBuilder<T> keys(Map<? extends String, ? extends String> keys) {
            if (keys == null) {
                throw new NullPointerException("keys cannot be null");
            }
            if (this.keys$key == null) {
                this.keys$key = new ArrayList();
                this.keys$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : keys.entrySet()) {
                this.keys$key.add($lombokEntry.getKey());
                this.keys$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CacheKeyBuilder<T> clearKeys() {
            if (this.keys$key != null) {
                this.keys$key.clear();
                this.keys$value.clear();
            }
            return this;
        }

        public CacheKeyBuilder<T> parameter(String parameterKey, String parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        public CacheKeyBuilder<T> parameters(Map<? extends String, ? extends String> parameters) {
            if (parameters == null) {
                throw new NullPointerException("parameters cannot be null");
            }
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CacheKeyBuilder<T> clearParameters() {
            if (this.parameters$key != null) {
                this.parameters$key.clear();
                this.parameters$value.clear();
            }
            return this;
        }

        public CacheKey<T> build() {
            Map<String, String> parameters;
            Map<String, String> keys;
            switch (this.keys$key == null ? 0 : this.keys$key.size()) {
                case 0: {
                    keys = Collections.emptyMap();
                    break;
                }
                case 1: {
                    keys = Collections.singletonMap(this.keys$key.get(0), this.keys$value.get(0));
                    break;
                }
                default: {
                    keys = new LinkedHashMap(this.keys$key.size() < 0x40000000 ? 1 + this.keys$key.size() + (this.keys$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.keys$key.size(); ++$i) {
                        keys.put(this.keys$key.get($i), this.keys$value.get($i));
                    }
                    keys = Collections.unmodifiableMap(keys);
                }
            }
            switch (this.parameters$key == null ? 0 : this.parameters$key.size()) {
                case 0: {
                    parameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    parameters = Collections.singletonMap(this.parameters$key.get(0), this.parameters$value.get(0));
                    break;
                }
                default: {
                    parameters = new LinkedHashMap<String, String>(this.parameters$key.size() < 0x40000000 ? 1 + this.parameters$key.size() + (this.parameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.parameters$key.size(); ++$i) {
                        parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                    }
                    parameters = Collections.unmodifiableMap(parameters);
                }
            }
            return new CacheKey<T>(this.method, keys, parameters);
        }

        public String toString() {
            return "CacheKey.CacheKeyBuilder(method=" + this.method + ", keys$key=" + this.keys$key + ", keys$value=" + this.keys$value + ", parameters$key=" + this.parameters$key + ", parameters$value=" + this.parameters$value + ")";
        }
    }
}

