/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.confluence;

import app.figma.server.AbstractFigmaHelper;
import app.figma.server.Figma;
import app.figma.server.HostHelper;
import app.figma.server.api.v100000000.dto.FigmaMetadataDTO;
import app.figma.server.api.v100000000.dto.LinkDTO;
import app.figma.server.api.v100000000.dto.ViewDTO;
import app.figma.server.api.v100000000.services.CacheSettingsService;
import app.figma.server.api.v100000000.services.LinkService;
import app.figma.server.api.v100000000.services.TokenService;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.MacroInstance;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentMacroService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;

@ConfluenceComponent
public class FigmaHelper
extends AbstractFigmaHelper {
    private final ContentMacroService contentMacroService;

    public FigmaHelper(TokenService tokenService, LinkService linkService, Figma figma, HostHelper helper, @ComponentImport ContentMacroService contentMacroService, CacheSettingsService cacheSettingsService, @ComponentImport CacheManager cacheManager, @ComponentImport EventPublisher eventPublisher) {
        super(tokenService, linkService, figma, helper, cacheSettingsService, cacheManager, eventPublisher);
        this.contentMacroService = contentMacroService;
    }

    @Override
    public Response legacyMacroView(String contentId, String macroId, String scale, String format, String forceRefresh) {
        try {
            Map<String, String> parameters = this.getMacroParameters(contentId, macroId);
            String fileKey = parameters.getOrDefault("fileKey", null);
            String nodeId = parameters.getOrDefault("nodeId", "0:1");
            LinkDTO link = LinkDTO.from(fileKey, nodeId, contentId);
            if (null != link) {
                String content;
                FigmaMetadataDTO metadata = this.metadata(link, forceRefresh);
                String string = content = !link.isPrototype() ? this.image(link, scale, format, forceRefresh) : null;
                if (null != metadata) {
                    ViewDTO result = new ViewDTO();
                    result.setId(String.format("legacyMacro_%s_%s", contentId, macroId));
                    result.setKey(link.getKey());
                    result.setNodeId(link.getNodeId());
                    result.setRevision(link.getRevision());
                    result.setPrototype(link.isPrototype());
                    result.setName(metadata.getName());
                    result.setFileName(metadata.getFileName());
                    result.setBackgroundColor(metadata.getBackgroundColor());
                    result.setWidth(metadata.getWidth());
                    result.setHeight(metadata.getHeight());
                    result.setLastModified(this.iso8601ToEpochMS(metadata.getLastModified()));
                    result.setProperties(parameters);
                    result.setStatus(ViewDTO.Status.complete);
                    result.setContent(content);
                    result.setVersion(metadata.getVersion());
                    result.setLatestVersion(metadata.getLatestVersion());
                    result.setParent(metadata.getParent());
                    return Response.ok((Object)result).build();
                }
            }
        }
        catch (Exception ignored) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private Map<String, String> getMacroParameters(String contentId, String macroId) {
        HashMap<String, String> result = new HashMap<String, String>();
        ContentMacroService.MacroInstanceFinder macroInstanceFinder = this.contentMacroService.findInContent(ContentId.of((long)Long.parseLong(contentId)), new Expansion[0]);
        Optional macroInstance = macroInstanceFinder.withMacroId(macroId).fetch();
        MacroInstance instance = macroInstance.orElse(null);
        if (null != instance) {
            Map params = instance.getParameters();
            params.forEach((key, param) -> result.put((String)key, param.getValue()));
        }
        return result;
    }
}

