/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.confluence;

import app.figma.server.HostHelper;
import app.figma.server.api.v100000000.dto.UserDTO;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import java.security.SecureRandom;
import java.util.Optional;

@ConfluenceComponent
public class ConfluenceHelper
implements HostHelper {
    private final PermissionManager permissionManager;
    private final SettingsManager settingsManager;
    private final ContentService contentService;

    ConfluenceHelper(@ConfluenceImport PermissionManager permissionManager, @ConfluenceImport SettingsManager settingsManager, @ConfluenceImport ContentService contentService) {
        this.permissionManager = permissionManager;
        this.settingsManager = settingsManager;
        this.contentService = contentService;
    }

    @Override
    public HostHelper.ApplicationNames getApplicationName() {
        return HostHelper.ApplicationNames.CONFLUENCE;
    }

    @Override
    public String getBaseURL() {
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    @Override
    public UserDTO getUser() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return new UserDTO(user.getKey().getStringValue());
    }

    @Override
    public SecureRandom getRandomGenerator() {
        return new SecureRandom();
    }

    @Override
    public boolean hasGlobalPermission(HostHelper.HostPermission hostPermission) {
        Permission permission = Permission.forName((String)hostPermission.name());
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission((User)user, permission, PermissionManager.TARGET_APPLICATION);
    }

    @Override
    public boolean hasEntityReadPermission(String refId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Optional content = this.contentService.find(new Expansion[0]).withId(ContentId.valueOf((String)refId)).fetch();
        Content page = content.orElse(null);
        return null != page && this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)page);
    }

    @Override
    public boolean hasEntityEditPermission(String refId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Optional content = this.contentService.find(new Expansion[0]).withId(ContentId.valueOf((String)refId)).fetch();
        Content page = content.orElse(null);
        return null != page && this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page);
    }
}

