/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.confluence;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.macro.browser.beans.MacroFormDetails;
import com.atlassian.confluence.macro.browser.beans.MacroMetadata;
import com.atlassian.confluence.macro.browser.beans.MacroParameter;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.resource.ResourcePhase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class ACMacro
implements Macro {
    private final HttpContext httpContext;
    private final PluginLicenseManager pluginLicenseManager;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final Plugin plugin;
    private final PageBuilderService pageBuilderService;

    @Autowired
    public ACMacro(@ComponentImport HttpContext httpContext, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport UserManager userManager, @ComponentImport PluginRetrievalService pluginRetrievalService, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport PageBuilderService pageBuilderService) {
        this.httpContext = httpContext;
        this.plugin = pluginRetrievalService.getPlugin();
        this.userManager = userManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.applicationProperties = applicationProperties;
        this.pageBuilderService = pageBuilderService;
    }

    public String execute(Map<String, String> params, String s, ConversionContext conversionContext) throws MacroExecutionException {
        try {
            MacroDefinition macroDefinition;
            RenderContext pageContext;
            MacroFormDetails formDetails;
            MacroMetadata metadata;
            HttpServletRequest req = this.httpContext.getRequest();
            MacroMetadata macroMetadata = metadata = conversionContext.hasProperty("macroMetadata") ? (MacroMetadata)conversionContext.getProperty("macroMetadata") : null;
            if (null != metadata && null != (formDetails = metadata.getFormDetails())) {
                List<MacroParameter> macroParameters = formDetails.getParameters().stream().filter(item -> !params.containsKey(item.getName()) && null != item.getDefaultValue() && !item.getDefaultValue().isEmpty()).collect(Collectors.toList());
                macroParameters.forEach(item -> params.put(item.getName(), item.getDefaultValue()));
            }
            RenderContext renderContext = pageContext = conversionContext.hasProperty("renderContext") ? (RenderContext)conversionContext.getProperty("renderContext") : null;
            if (pageContext instanceof PageContext) {
                String refId = ((PageContext)pageContext).getEntity().getContentId().toString();
                params.put("refId", refId);
            }
            MacroDefinition macroDefinition2 = macroDefinition = conversionContext.hasProperty("macroDefinition") ? (MacroDefinition)conversionContext.getProperty("macroDefinition") : null;
            if (null != macroDefinition) {
                macroDefinition.getMacroIdentifier().ifPresent(macroId -> params.put("entityId", macroId.getId()));
            }
            String moduleName = conversionContext.hasProperty("macroName") ? conversionContext.getPropertyAsString("macroName") : "";
            String moduleKey = params.getOrDefault("entityId", moduleName);
            return this.toHost(req, moduleKey, params);
        }
        catch (Exception exp) {
            throw new MacroExecutionException((Throwable)exp);
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    private String toHost(HttpServletRequest req, String moduleKey, Map<String, String> macroData) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.pageBuilderService.assembler().resources().requireContext(ResourcePhase.DEFER, String.format("%s-%s-atlassian-connect", this.plugin.getKey(), this.plugin.getPluginInformation().getVersion()));
        HashMap<String, String> params = new HashMap<String, String>();
        Optional<String> userKey = Optional.of(Objects.requireNonNull(this.userManager.getRemoteUserKey()).getStringValue());
        params.put("ajs-remote-user-key", userKey.orElse(""));
        params.put("atl-product-name", this.getPlatformName());
        Object urlSuffix = params.getOrDefault("url", "/");
        urlSuffix = (String)urlSuffix + String.format("%s%s", ((String)urlSuffix).contains("?") ? "&" : "?", String.join((CharSequence)"&", this.getQueryStringParameters(req, macroData)));
        sb.append("<html>");
        sb.append("<head>");
        params.forEach((k, v) -> sb.append(String.format("<meta name=\"%s\" content=\"%s\">", k, v)));
        sb.append("</head>");
        sb.append("<body>");
        sb.append(String.format("<iframe src=\"%1$s/plugins/servlet/atlassian-connect/macro/%2$s/%3$s%4$s\" style=\"border:none; overflow: hidden; width: 100%%;\" data-ap-appkey=\"%2$s\" data-ap-key=\"%3$s\"></iframe>", req.getContextPath(), this.plugin.getKey(), moduleKey, urlSuffix));
        sb.append("</body>");
        return sb.toString();
    }

    private String[] getQueryStringParameters(HttpServletRequest req, Map<String, String> macroData) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        macroData.forEach((key, value) -> {
            if (!": = | RAW | = :".equals(key)) {
                parameters.put((String)key, (String)value);
            }
        });
        String port = req.getServerPort() == 80 || req.getServerPort() == 443 ? "" : String.format(":%s", req.getServerPort());
        parameters.put("xdm_e", String.format("%s://%s%s", req.getScheme(), req.getServerName(), port));
        parameters.put("cp", req.getContextPath());
        parameters.put("lic", this.getLicenseState());
        parameters.put("xdm_c", "DO_NOT_USE");
        parameters.put("cv", "DO_NOT_USE");
        return (String[])parameters.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).toArray(String[]::new);
    }

    private String getLicenseState() {
        if (!this.isLicenseEnabled()) {
            return "active";
        }
        Option license = this.pluginLicenseManager.getLicense();
        return license.isDefined() && ((PluginLicense)license.get()).isValid() ? "active" : "none";
    }

    private boolean isLicenseEnabled() {
        Map params = this.plugin.getPluginInformation().getParameters();
        return !params.containsKey("atlassian-licensing-enabled") || Boolean.parseBoolean((String)params.get("atlassian-licensing-enabled"));
    }

    private String getPlatformName() {
        String platformId = this.applicationProperties.getPlatformId();
        switch (platformId.toLowerCase()) {
            case "jira": {
                return "Jira";
            }
            case "conf": {
                return "Confluence";
            }
        }
        return "";
    }
}

