/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.services;

import app.figma.server.api.v100000000.dto.TokenDTO;
import app.figma.server.api.v100000000.repositories.TokenRepository;
import app.figma.server.api.v100000000.services.AbstractService;
import app.figma.server.entities.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenService
extends AbstractService<Token, TokenDTO> {
    @Autowired
    public TokenService(TokenRepository tokenRepository) {
        super(tokenRepository);
    }

    @Override
    public TokenDTO toDTO(Token entity) {
        return new TokenDTO(entity);
    }

    @Override
    public Token toEntity(TokenDTO dto, Token entity) {
        entity.setName(dto.getName());
        entity.setAccountId(dto.getAccountId());
        if (!dto.getToken().startsWith("***")) {
            entity.setToken(dto.getToken());
        }
        return entity;
    }

    @Override
    public boolean isValidEntity(Token entity) {
        if (null == entity.getName()) {
            return false;
        }
        if (null == entity.getAccountId()) {
            return false;
        }
        return null != entity.getToken();
    }

    @Override
    public boolean isValidEntity(TokenDTO dto) {
        if (null == dto.getName()) {
            return false;
        }
        if (null == dto.getAccountId()) {
            return false;
        }
        return null != dto.getToken();
    }
}

