/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.services;

import app.figma.server.api.v100000000.dto.LinkDTO;
import app.figma.server.api.v100000000.repositories.LinkRepository;
import app.figma.server.api.v100000000.services.AbstractService;
import app.figma.server.entities.Link;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkService
extends AbstractService<Link, LinkDTO> {
    @Autowired
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public LinkService(LinkRepository repository) {
        super(repository);
    }

    @Override
    public LinkDTO toDTO(Link entity) {
        return new LinkDTO(entity);
    }

    @Override
    public Link toEntity(LinkDTO dto, Link entity) {
        entity.setKey(dto.getKey());
        entity.setNodeId(dto.getNodeId());
        entity.setRevision(dto.getRevision());
        entity.setPrototype(dto.isPrototype());
        entity.setRefId(dto.getRefId());
        entity.setEntityId(dto.getEntityId());
        entity.setExpires(dto.getExpires());
        if (null != dto.getProperties() && !dto.getProperties().isEmpty()) {
            List properties = dto.getProperties().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.toList());
            entity.setProperties(String.join((CharSequence)";", properties));
        }
        return entity;
    }

    @Override
    public boolean isValidEntity(Link entity) {
        if (null == entity.getKey()) {
            return false;
        }
        return null != entity.getRefId();
    }

    @Override
    public boolean isValidEntity(LinkDTO dto) {
        if (null == dto.getKey()) {
            return false;
        }
        return null != dto.getRefId();
    }
}

