/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.services;

import app.figma.server.api.v100000000.dto.DTO;
import app.figma.server.api.v100000000.helpers.Page;
import app.figma.server.api.v100000000.repositories.Repository;
import app.figma.server.api.v100000000.services.Service;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import net.java.ao.Entity;
import net.java.ao.Query;

public abstract class AbstractService<T extends Entity, X extends DTO>
implements Service<T, X> {
    protected final Repository<T> repository;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AbstractService(Repository<T> repository) {
        this.repository = repository;
    }

    @Override
    public T findById(int id) {
        return this.repository.findById(id);
    }

    @Override
    public T findOne(Query query) {
        return this.repository.findOne(query);
    }

    @Override
    public Page<T> findAll() {
        return this.findAll(Query.select());
    }

    @Override
    public Page<T> findAll(Query query) {
        List<T> result = this.repository.findAll(query);
        int totalCount = this.repository.getCount(query);
        int start = query != null && query.getOffset() != -1 ? query.getOffset() : 0;
        boolean isLast = (long)start + (long)result.size() == (long)totalCount;
        return Page.builder().isLast(isLast).size(result.size()).start(start).total(Long.valueOf(totalCount)).values(ImmutableList.copyOf(result)).build();
    }

    @Override
    public int getCount() {
        return this.repository.getCount();
    }

    @Override
    public int getCount(Query query) {
        return this.repository.getCount(query);
    }

    @Override
    public T createOrUpdate(X dto) {
        int entityId = !Strings.isNullOrEmpty((String)((DTO)dto).getId()) ? Integer.parseInt(((DTO)dto).getId()) : -1;
        return this.repository.getOrCreate(entityId);
    }

    @Override
    public void delete(int id) {
        this.repository.delete(id);
    }

    @Override
    public void delete(X dto) {
        if (!Strings.isNullOrEmpty((String)((DTO)dto).getId())) {
            int entityId = Integer.parseInt(((DTO)dto).getId());
            this.repository.delete(entityId);
        }
    }

    @Override
    public void delete(T entity) {
        this.repository.delete(entity);
    }

    @Override
    public void delete(Query query) {
        this.repository.delete(query);
    }

    @Override
    public void reset() {
        this.repository.reset();
    }

    @Override
    public abstract X toDTO(T var1);

    @Override
    public abstract T toEntity(X var1, T var2);

    @Override
    public abstract boolean isValidEntity(T var1);

    @Override
    public abstract boolean isValidEntity(X var1);
}

