/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.repositories;

import app.figma.server.api.v100000000.repositories.Repository;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public abstract class AbstractRepository<T extends Entity>
implements Repository<T> {
    private final Class<T> type;
    protected final ActiveObjects activeObjects;

    AbstractRepository(Class<T> type, ActiveObjects activeObjects) {
        this.type = type;
        this.activeObjects = activeObjects;
    }

    @Override
    public T findById(int id) {
        return (T)((Entity)this.activeObjects.get(this.type, (Object)id));
    }

    @Override
    public T findOne(Query query) {
        Entity[] result = (Entity[])this.activeObjects.find(this.type, query.limit(1));
        return (T)(result.length > 0 ? result[0] : null);
    }

    @Override
    public List<T> findAll() {
        return Lists.newArrayList((Object[])((Entity[])this.activeObjects.find(this.type)));
    }

    @Override
    public List<T> findAll(Query query) {
        return Lists.newArrayList((Object[])((Entity[])this.activeObjects.find(this.type, query)));
    }

    @Override
    public int getCount() {
        return this.activeObjects.count(this.type);
    }

    @Override
    public int getCount(Query query) {
        Query countQuery = Query.select((String)String.join((CharSequence)",", query.getFields()));
        countQuery.setWhereParams(query.getWhereParams());
        countQuery.setWhereClause(query.getWhereClause());
        countQuery.setDistinct(query.isDistinct());
        countQuery.setGroupClause(query.getGroupClause());
        countQuery.setJoins(query.getJoins());
        countQuery.setTable(query.getTable());
        countQuery.setTableType(query.getTableType());
        return this.activeObjects.count(this.type, countQuery);
    }

    @Override
    public T getOrCreate(int id) {
        Object result = this.findById(id);
        if (result == null) {
            result = (Entity)this.activeObjects.create(this.type, new DBParam[0]);
        }
        return result;
    }

    @Override
    public T getOrCreate(Query query) {
        Object result = this.findOne(query);
        if (result == null) {
            result = (Entity)this.activeObjects.create(this.type, new DBParam[0]);
        }
        return result;
    }

    @Override
    public void delete(int id) {
        T entity = this.findById(id);
        this.delete(entity);
    }

    @Override
    public void delete(T entity) {
        if (entity != null) {
            this.deleteConstraints(entity);
            this.activeObjects.delete(new RawEntity[]{entity});
        }
    }

    @Override
    public void delete(Query query) {
        this.activeObjects.stream(this.type, query, this::deleteConstraints);
        this.reset(this.type, query);
    }

    @Override
    public void reset() {
        this.activeObjects.stream(this.type, this::deleteConstraints);
        this.reset(this.type, Query.select());
    }

    protected <Y extends Entity> void reset(Class<Y> type, Query query) {
        ArrayList listOfEntryIds = Lists.newArrayList();
        this.activeObjects.stream(type, query, entity -> listOfEntryIds.add(entity.getID()));
        ArrayList listOfIds = Lists.newArrayList((Iterable)listOfEntryIds);
        while (!listOfIds.isEmpty()) {
            int numOfItemsLeft = listOfIds.size();
            List itemsToDelete = numOfItemsLeft > 1000 ? listOfIds.subList(0, 1000) : listOfIds.subList(0, numOfItemsLeft);
            ArrayList placeHolder = Lists.newArrayList();
            itemsToDelete.forEach(item -> placeHolder.add("?"));
            String sql = String.format("ID IN (%s)", String.join((CharSequence)",", placeHolder));
            this.activeObjects.deleteWithSQL(type, sql, itemsToDelete.toArray());
            listOfIds = numOfItemsLeft > 1000 ? listOfIds.subList(1001, listOfIds.size()) : Lists.newArrayList();
        }
    }

    protected abstract void deleteConstraints(T var1);
}

