/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.repositories;

import app.figma.server.api.v100000000.repositories.AbstractRepository;
import app.figma.server.entities.SerializableEntity;
import app.figma.server.helpers.CacheKey;
import app.figma.server.helpers.Option;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.java.ao.Query;

public abstract class AbstractCachedRepository<T extends SerializableEntity>
extends AbstractRepository<T> {
    private final Cache<CacheKey<CachedMethods>, Option<?>> cache;

    AbstractCachedRepository(Class<T> type, ActiveObjects activeObjects, CacheManager cacheManager) {
        super(type, activeObjects);
        this.cache = cacheManager.getCache(String.format(this.getClass().getCanonicalName(), type.getCanonicalName()), this.getCacheLoader(), new CacheSettingsBuilder().remote().expireAfterWrite(5L, TimeUnit.MINUTES).build());
    }

    @Override
    public T findById(int id) {
        return this.findById(id, true);
    }

    protected T findById(int id, boolean fromCache) {
        if (fromCache) {
            Option result = (Option)this.cache.get(CacheKey.builder().key("method", CachedMethods.findById.name()).key("id", String.valueOf(id)).parameter("id", String.valueOf(id)).build());
            return (T)(result != null ? (SerializableEntity)result.getValue() : null);
        }
        return (T)((SerializableEntity)super.findById(id));
    }

    @Override
    public T findOne(Query query) {
        return this.findOne(true);
    }

    protected T findOne(boolean fromCache) {
        if (fromCache) {
            Option result = (Option)this.cache.get(CacheKey.builder().key("method", CachedMethods.findOne.name()).build());
            return (T)(result != null ? (SerializableEntity)result.getValue() : null);
        }
        return (T)((SerializableEntity)super.findOne(Query.select()));
    }

    @Override
    public List<T> findAll() {
        return this.findAll(true);
    }

    protected List<T> findAll(boolean fromCache) {
        if (fromCache) {
            Option result = (Option)this.cache.get(CacheKey.builder().key("method", CachedMethods.findOne.name()).build());
            return result != null ? Lists.newArrayList((Object[])((SerializableEntity[])result.getValue())) : null;
        }
        return super.findAll();
    }

    @Override
    protected abstract void deleteConstraints(T var1);

    private CacheLoader<CacheKey<CachedMethods>, Option<?>> getCacheLoader() {
        final AbstractCachedRepository repository = this;
        return new CacheLoader<CacheKey<CachedMethods>, Option<?>>(){

            @Nonnull
            public Option<?> load(@Nonnull CacheKey<CachedMethods> cacheKey) {
                try {
                    CachedMethods method = CachedMethods.valueOf(cacheKey.getParameters().get("method"));
                    switch (method) {
                        case findById: {
                            int id = Integer.parseInt(cacheKey.getParameters().get("id"));
                            Object entityById = repository.findById(id, false);
                            return new Option(entityById);
                        }
                        case findOne: {
                            Object entityByOne = repository.findOne(false);
                            return new Option(entityByOne);
                        }
                        case findAll: {
                            List allEntities = repository.findAll(false);
                            return new Option<Object[]>(allEntities.toArray());
                        }
                    }
                    return new Option<Object>(null);
                }
                catch (IllegalArgumentException ignored) {
                    return new Option<Object>(null);
                }
            }
        };
    }

    static enum CachedMethods {
        findById,
        findOne,
        findAll,
        getCount;

    }
}

