/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.helpers;

import com.google.common.collect.ImmutableList;

public class Page<T> {
    private int start;
    private Long total;
    private int size;
    private boolean isLast;
    private ImmutableList<T> values;

    Page(int start, Long total, int size, boolean isLast, ImmutableList<T> values) {
        this.start = start;
        this.total = total;
        this.size = size;
        this.isLast = isLast;
        this.values = values;
    }

    public static <T> PageBuilder<T> builder() {
        return new PageBuilder();
    }

    public int getStart() {
        return this.start;
    }

    public Long getTotal() {
        return this.total;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public ImmutableList<T> getValues() {
        return this.values;
    }

    public static class PageBuilder<T> {
        private int start;
        private Long total;
        private int size;
        private boolean isLast;
        private ImmutableList<T> values;

        PageBuilder() {
        }

        public PageBuilder<T> start(int start) {
            this.start = start;
            return this;
        }

        public PageBuilder<T> total(Long total) {
            this.total = total;
            return this;
        }

        public PageBuilder<T> size(int size) {
            this.size = size;
            return this;
        }

        public PageBuilder<T> isLast(boolean isLast) {
            this.isLast = isLast;
            return this;
        }

        public PageBuilder<T> values(ImmutableList<T> values) {
            this.values = values;
            return this;
        }

        public Page<T> build() {
            return new Page<T>(this.start, this.total, this.size, this.isLast, this.values);
        }

        public String toString() {
            return "Page.PageBuilder(start=" + this.start + ", total=" + this.total + ", size=" + this.size + ", isLast=" + this.isLast + ", values=" + this.values + ")";
        }
    }
}

