/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.helpers;

import com.figma.api.dto.Color;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class NodeTree {
    private String id;
    private String name;
    private String type;
    private Double width;
    private Double height;
    private List<NodeTree> children;
    private String lastModified;
    private Color backgroundColor;
    private NodeTree parent;

    NodeTree(String id, String name, String type, Double width, Double height, List<NodeTree> children, String lastModified, Color backgroundColor, NodeTree parent) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.width = width;
        this.height = height;
        this.children = children;
        this.lastModified = lastModified;
        this.backgroundColor = backgroundColor;
        this.parent = parent;
    }

    public static NodeTreeBuilder builder() {
        return new NodeTreeBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Double getWidth() {
        return this.width;
    }

    public Double getHeight() {
        return this.height;
    }

    public List<NodeTree> getChildren() {
        return this.children;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public NodeTree getParent() {
        return this.parent;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public void setChildren(List<NodeTree> children) {
        this.children = children;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setParent(NodeTree parent) {
        this.parent = parent;
    }

    public static class NodeTreeBuilder {
        private String id;
        private String name;
        private String type;
        private Double width;
        private Double height;
        private List<NodeTree> children;
        private String lastModified;
        private Color backgroundColor;
        private NodeTree parent;

        NodeTreeBuilder() {
        }

        public NodeTreeBuilder id(String id) {
            this.id = id;
            return this;
        }

        public NodeTreeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NodeTreeBuilder type(String type) {
            this.type = type;
            return this;
        }

        public NodeTreeBuilder width(Double width) {
            this.width = width;
            return this;
        }

        public NodeTreeBuilder height(Double height) {
            this.height = height;
            return this;
        }

        public NodeTreeBuilder children(List<NodeTree> children) {
            this.children = children;
            return this;
        }

        public NodeTreeBuilder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public NodeTreeBuilder backgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public NodeTreeBuilder parent(NodeTree parent) {
            this.parent = parent;
            return this;
        }

        public NodeTree build() {
            return new NodeTree(this.id, this.name, this.type, this.width, this.height, this.children, this.lastModified, this.backgroundColor, this.parent);
        }

        public String toString() {
            return "NodeTree.NodeTreeBuilder(id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", width=" + this.width + ", height=" + this.height + ", children=" + this.children + ", lastModified=" + this.lastModified + ", backgroundColor=" + this.backgroundColor + ", parent=" + this.parent + ")";
        }
    }
}

