/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.dto;

import app.figma.server.api.v100000000.dto.DTO;
import app.figma.server.api.v100000000.dto.FigmaMetadataDTO;
import app.figma.server.api.v100000000.dto.FigmaVersionDTO;
import app.figma.server.api.v100000000.dto.LinkDTO;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class ViewDTO
extends DTO {
    private String id;
    private String key;
    private String nodeId;
    private String revision;
    private Boolean prototype;
    private String name;
    private String fileName;
    private String backgroundColor;
    private Double width;
    private Double height;
    private Long lastModified;
    private Map<String, String> properties;
    private String content;
    private Status status;
    private FigmaVersionDTO version;
    private FigmaVersionDTO latestVersion;
    private FigmaMetadataDTO.ParentFile parent;

    public ViewDTO() {
    }

    public ViewDTO(ViewDTO data) {
        super(data.getId());
        this.key = data.key;
        this.nodeId = data.nodeId;
        this.revision = data.revision;
        this.prototype = data.prototype;
        this.name = data.name;
        this.fileName = data.fileName;
        this.backgroundColor = data.backgroundColor;
        this.width = data.width;
        this.height = data.height;
        this.lastModified = data.lastModified;
        this.properties = data.properties;
        this.content = data.content;
        this.status = data.status;
        this.version = data.version;
        this.latestVersion = data.latestVersion;
        this.parent = data.parent;
    }

    public static ViewDTO from(LinkDTO link) {
        ViewDTO result = new ViewDTO();
        result.setId(link.getId());
        result.setKey(link.getKey());
        result.setNodeId(link.getNodeId());
        result.setRevision(link.getRevision());
        result.setPrototype(link.isPrototype());
        result.setProperties(link.getProperties());
        return result;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getRevision() {
        return this.revision;
    }

    public Boolean getPrototype() {
        return this.prototype;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public Double getWidth() {
        return this.width;
    }

    public Double getHeight() {
        return this.height;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getContent() {
        return this.content;
    }

    public Status getStatus() {
        return this.status;
    }

    public FigmaVersionDTO getVersion() {
        return this.version;
    }

    public FigmaVersionDTO getLatestVersion() {
        return this.latestVersion;
    }

    public FigmaMetadataDTO.ParentFile getParent() {
        return this.parent;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setPrototype(Boolean prototype) {
        this.prototype = prototype;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setVersion(FigmaVersionDTO version) {
        this.version = version;
    }

    public void setLatestVersion(FigmaVersionDTO latestVersion) {
        this.latestVersion = latestVersion;
    }

    public void setParent(FigmaMetadataDTO.ParentFile parent) {
        this.parent = parent;
    }

    public static enum Status {
        processing,
        loading,
        complete,
        error;

    }
}

