/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.dto;

import app.figma.server.api.v100000000.helpers.Page;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class PageDTO<T> {
    private final int start;
    private final int size;
    private final Long total;
    private final List<T> values;
    private final boolean last;

    public PageDTO(int start, int size, Long total, List<T> values, boolean last) {
        ImmutableList valuesList = ImmutableList.copyOf(values);
        this.last = last;
        this.size = size;
        this.start = start;
        this.total = total;
        this.values = valuesList;
    }

    public static <T> PageDTO<T> from(@Nonnull Page<T> page) {
        return new PageDTO<T>(page.getStart(), page.getSize(), page.getTotal(), page.getValues(), page.isLast());
    }

    public static <T> PageDTO<T> from(@Nonnull List<T> values) {
        return new PageDTO<T>(0, values.size(), Long.valueOf(values.size()), values, true);
    }

    public static <T, X> PageDTO<X> from(@Nonnull Page<T> page, Function<T, X> transform) {
        List items = page.getValues().stream().map(transform).collect(Collectors.toList());
        return new PageDTO(page.getStart(), page.getSize(), page.getTotal(), items, page.isLast());
    }

    public static <T> PageDTOBuilder<T> builder() {
        return new PageDTOBuilder();
    }

    public int getStart() {
        return this.start;
    }

    public int getSize() {
        return this.size;
    }

    public Long getTotal() {
        return this.total;
    }

    public List<T> getValues() {
        return this.values;
    }

    public boolean isLast() {
        return this.last;
    }

    public static class PageDTOBuilder<T> {
        private int start;
        private int size;
        private Long total;
        private List<T> values;
        private boolean last;

        PageDTOBuilder() {
        }

        public PageDTOBuilder<T> start(int start) {
            this.start = start;
            return this;
        }

        public PageDTOBuilder<T> size(int size) {
            this.size = size;
            return this;
        }

        public PageDTOBuilder<T> total(Long total) {
            this.total = total;
            return this;
        }

        public PageDTOBuilder<T> values(List<T> values) {
            this.values = values;
            return this;
        }

        public PageDTOBuilder<T> last(boolean last) {
            this.last = last;
            return this;
        }

        public PageDTO<T> build() {
            return new PageDTO<T>(this.start, this.size, this.total, this.values, this.last);
        }

        public String toString() {
            return "PageDTO.PageDTOBuilder(start=" + this.start + ", size=" + this.size + ", total=" + this.total + ", values=" + this.values + ", last=" + this.last + ")";
        }
    }
}

