/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.dto;

import app.figma.server.Constants;
import app.figma.server.api.v100000000.dto.DTO;
import app.figma.server.api.v100000000.dto.ViewDTO;
import app.figma.server.entities.Link;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class LinkDTO
extends DTO {
    private String key;
    private String nodeId;
    private String revision;
    private boolean prototype;
    private String refId;
    private String entityId;
    private Map<String, String> properties;
    private long expires;

    public LinkDTO() {
    }

    public LinkDTO(String key, String nodeId) {
        this.key = key;
        this.nodeId = nodeId;
    }

    public LinkDTO(String key, String nodeId, String refId) {
        this(key, nodeId);
        this.refId = refId;
    }

    public LinkDTO(Link entity) {
        super(String.valueOf(entity.getID()));
        this.key = entity.getKey();
        this.nodeId = entity.getNodeId();
        this.revision = entity.getRevision();
        this.prototype = entity.isPrototype();
        this.refId = entity.getRefId();
        this.entityId = entity.getEntityId();
        this.properties = new HashMap<String, String>();
        this.expires = entity.getExpires();
        if (null != entity.getProperties()) {
            String[] values = entity.getProperties().split(";");
            Arrays.stream(values).forEach(entry -> {
                String[] item = entry.split("=");
                this.properties.put(item[0], item[1]);
            });
        }
    }

    public static LinkDTO from(LinkDTO link) {
        LinkDTO result = new LinkDTO();
        result.setId(link.getId());
        result.setKey(link.getKey());
        result.setNodeId(link.getNodeId());
        return result;
    }

    public static LinkDTO from(ViewDTO view) {
        LinkDTO result = new LinkDTO();
        result.setId(view.getId());
        result.setKey(view.getKey());
        result.setNodeId(view.getNodeId());
        return result;
    }

    public static LinkDTO from(String key, String nodeId, String refId) {
        try {
            return Constants.FIGMA_KEY_REGEXP.matcher(key).matches() ? new LinkDTO(key, nodeId, refId) : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static LinkDTO from(String url, String refId) {
        try {
            if (null != url && !url.isEmpty()) {
                Matcher figmaUrlMatcher;
                Matcher matcher = Constants.FIGMA_BRANCH_URL_REGEXP.matcher(url).matches() ? Constants.FIGMA_BRANCH_URL_REGEXP.matcher(url) : (figmaUrlMatcher = Constants.FIGMA_URL_REGEXP.matcher(url).matches() ? Constants.FIGMA_URL_REGEXP.matcher(url) : null);
                if (null != figmaUrlMatcher && figmaUrlMatcher.matches() && figmaUrlMatcher.groupCount() == 4) {
                    String key = figmaUrlMatcher.group(3);
                    String type = figmaUrlMatcher.group(2);
                    List URI2 = URLEncodedUtils.parse((URI)new URI(url), (Charset)StandardCharsets.UTF_8);
                    String nodeId = (String)URI2.stream().filter(item -> item.getName().equals("nodeId")).findFirst().map(NameValuePair::getValue).orElse("");
                    LinkDTO result = new LinkDTO(key, nodeId, refId);
                    result.setPrototype(type.equalsIgnoreCase("proto"));
                    return result;
                }
            }
            return null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public String getRefId() {
        return this.refId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setPrototype(boolean prototype) {
        this.prototype = prototype;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }
}

