/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.controllers;

import app.figma.server.HostHelper;
import app.figma.server.api.v100000000.controllers.AbstractController;
import app.figma.server.api.v100000000.controllers.DefaultController;
import app.figma.server.api.v100000000.dto.PageDTO;
import app.figma.server.api.v100000000.dto.TokenDTO;
import app.figma.server.api.v100000000.dto.UserDTO;
import app.figma.server.api.v100000000.services.TokenService;
import app.figma.server.entities.Token;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.springframework.web.server.ResponseStatusException;

@Path(value="/token")
public class TokenController
extends DefaultController<Token, TokenDTO> {
    TokenController(HostHelper helper, TokenService tokenService) {
        super(tokenService, helper);
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, UriInfo context) {
        return true;
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, int id) {
        return true;
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, TokenDTO item) {
        return true;
    }

    @Override
    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response readRequest(@Context UriInfo ctx) {
        try {
            PageDTO result = super.read(ctx);
            UserDTO user = this.helper.getUser();
            List filteredTokens = result.getValues().stream().filter(item -> item.getAccountId().equals(user.getAccountId())).collect(Collectors.toList());
            return Response.ok(PageDTO.from(filteredTokens)).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @Override
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response readRequest(@PathParam(value="id") int id) {
        try {
            TokenDTO result = (TokenDTO)super.read(id);
            if (null != result) {
                UserDTO user = this.helper.getUser();
                if (user.getAccountId().equals(result.getAccountId())) {
                    return Response.ok((Object)result).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @Override
    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response createRequest(TokenDTO item) {
        UserDTO user = this.helper.getUser();
        item.setAccountId(user.getAccountId());
        return super.createRequest(item);
    }

    @Override
    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response updateRequest(@PathParam(value="id") int id, TokenDTO item) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @Override
    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response removeRequest(@PathParam(value="id") int id) {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

