/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.controllers;

import app.figma.server.HostHelper;
import app.figma.server.api.v100000000.controllers.AbstractController;
import app.figma.server.api.v100000000.controllers.DefaultController;
import app.figma.server.api.v100000000.dto.PageDTO;
import app.figma.server.api.v100000000.dto.TokenDTO;
import app.figma.server.api.v100000000.dto.UserDTO;
import app.figma.server.api.v100000000.services.TokenService;
import app.figma.server.entities.Token;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.java.ao.Query;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;

@Path(value="/admin/token")
public class TokenAdminController
extends DefaultController<Token, TokenDTO> {
    TokenAdminController(HostHelper helper, TokenService tokenService) {
        super(tokenService, helper);
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, UriInfo context) {
        return this.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER);
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, int id) {
        return this.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER);
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, TokenDTO item) {
        return this.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER);
    }

    @Override
    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response readRequest(@Context UriInfo ctx) {
        try {
            PageDTO result = super.read(ctx);
            MultivaluedMap parameters = ctx.getQueryParameters();
            String filter = (String)parameters.getFirst((Object)"filter");
            if (null != filter && !filter.isEmpty() && !filter.isBlank()) {
                List filteredItems = result.getValues().stream().filter(item -> item.getName().toLowerCase().contains(filter.toLowerCase())).collect(Collectors.toList());
                return Response.ok(PageDTO.from(filteredItems)).build();
            }
            return Response.ok(result).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @Override
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response readRequest(@PathParam(value="id") int id) {
        try {
            TokenDTO result = (TokenDTO)super.read(id);
            if (null != result) {
                return Response.ok((Object)result).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @Override
    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response createRequest(TokenDTO item) {
        UserDTO user = this.helper.getUser();
        item.setAccountId(user.getAccountId());
        return super.createRequest(item);
    }

    @Override
    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response updateRequest(@PathParam(value="id") int id, TokenDTO item) {
        try {
            if (null == item.getId() || id != Integer.parseInt(item.getId())) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST);
            }
            if (null == item.getToken() || item.getToken().startsWith("***")) {
                Token current = (Token)this.service.findById(Integer.parseInt(item.getId()));
                if (null != current) {
                    item.setToken(current.getToken());
                    item.setAccountId(current.getAccountId());
                } else {
                    throw new ResponseStatusException(HttpStatus.BAD_REQUEST);
                }
            }
            return super.updateRequest(id, item);
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @Override
    protected Query toQuery(UriInfo ctx) {
        return super.toQuery(ctx, null, (key, value, query) -> {
            if ("filter".equals(key) && !value.isEmpty()) {
                return this.addWhereClause(query, "LOWER(\"NAME\") LIKE LOWER(?)", "%" + value + "%");
            }
            return query;
        });
    }
}

