/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.controllers;

import app.figma.server.Figma;
import app.figma.server.HostHelper;
import app.figma.server.api.v100000000.controllers.AbstractController;
import app.figma.server.api.v100000000.dto.FigmaVersionDTO;
import app.figma.server.api.v100000000.dto.LinkDTO;
import app.figma.server.api.v100000000.dto.PageDTO;
import app.figma.server.api.v100000000.dto.UserDTO;
import app.figma.server.api.v100000000.helpers.Page;
import app.figma.server.api.v100000000.services.LinkService;
import app.figma.server.api.v100000000.services.TokenService;
import app.figma.server.entities.Link;
import app.figma.server.entities.Token;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.java.ao.Query;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;

@Path(value="/link")
public class LinkController
extends AbstractController<Link, LinkDTO> {
    private final TokenService tokenService;
    private final Figma figmaService;

    LinkController(HostHelper helper, LinkService service, TokenService tokenService, Figma cachedFigmaService) {
        super(service, helper);
        this.tokenService = tokenService;
        this.figmaService = cachedFigmaService;
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, UriInfo context) {
        return true;
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, int id) {
        return true;
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, LinkDTO item) {
        return true;
    }

    @GET
    @Path(value="/{id}/canEdit")
    public Response canEdit(@PathParam(value="id") String id) {
        String refId;
        if (id.startsWith("legacyMacro")) {
            return Response.ok((Object)false).build();
        }
        Link result = (Link)this.service.findById(Integer.parseInt(id));
        if (null != result && null != (refId = result.getRefId())) {
            return Response.ok((Object)this.helper.hasEntityEditPermission(refId)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response readRequest(@Context UriInfo ctx) {
        try {
            PageDTO result = super.read(ctx);
            List linksAccessibleToUser = result.getValues().stream().filter(item -> null != item.getRefId() && this.helper.hasEntityReadPermission(item.getRefId())).collect(Collectors.toList());
            return Response.ok(PageDTO.from(linksAccessibleToUser)).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response readRequest(@PathParam(value="id") int id) {
        try {
            LinkDTO result = (LinkDTO)super.read(id);
            if (null != result) {
                boolean isAuthorized;
                boolean bl = isAuthorized = null != result.getRefId() && this.helper.hasEntityReadPermission(result.getRefId());
                if (isAuthorized) {
                    return Response.ok((Object)result).build();
                }
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @POST
    @Path(value="/")
    public Response createRequest(LinkDTO item) {
        try {
            if (null == item.getKey() || null == item.getRefId()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            boolean isAuthorized = this.helper.hasEntityEditPermission(item.getRefId());
            if (isAuthorized) {
                Token token = this.getTokenByKey(item.getKey());
                if (null != token) {
                    FigmaVersionDTO latestVersion;
                    if (null == item.getRevision() && null != (latestVersion = this.figmaService.latestVersion(token.getToken(), item.getKey(), true))) {
                        item.setRevision(latestVersion.getId());
                    }
                    LinkDTO result = super.create(item);
                    return Response.ok((Object)result).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response updateRequest(@PathParam(value="id") int id, LinkDTO item) {
        try {
            if (null == item.getKey() || null == item.getRefId()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            boolean isAuthorized = this.helper.hasEntityEditPermission(item.getRefId());
            if (isAuthorized) {
                Token token = this.getTokenByKey(item.getKey());
                if (null != token) {
                    LinkDTO result = super.update(id, item);
                    return Response.ok((Object)result).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response removeRequest(@PathParam(value="id") int id) {
        try {
            boolean isAuthorized;
            LinkDTO result = (LinkDTO)super.read(id);
            boolean bl = isAuthorized = null != result && this.helper.hasEntityEditPermission(result.getRefId());
            if (isAuthorized) {
                super.remove(id);
                return Response.noContent().build();
            }
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    private Token getTokenByKey(String key) {
        UserDTO user = this.helper.getUser();
        Page tokens = this.tokenService.findAll(Query.select().where("ACCOUNT_ID = ?", new Object[]{user.getAccountId()}));
        return tokens.getValues().stream().filter(token -> this.figmaService.validate(token.getToken(), key, false)).findFirst().orElse(null);
    }

    @Override
    protected Query toQuery(UriInfo ctx) {
        return super.toQuery(ctx, null, (key, value, query) -> {
            switch (key) {
                case "id": {
                    return this.addWhereClause(query, "ID = ?", Integer.parseInt(value));
                }
                case "entityId": {
                    return this.addWhereClause(query, "ENTITY_ID = ?", value);
                }
                case "nodeId": {
                    return this.addWhereClause(query, "NODE_ID = ?", value);
                }
                case "refId": {
                    return this.addWhereClause(query, "REF_ID = ?", value);
                }
            }
            return this.addWhereClause(query, String.format("%s = ?", key.toUpperCase()), value);
        });
    }
}

