/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.controllers;

import app.figma.server.FigmaHelper;
import app.figma.server.FigmaService;
import app.figma.server.HostHelper;
import app.figma.server.api.v100000000.dto.FigmaErrorDTO;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
public class FigmaAdminController {
    private static final Logger log = LoggerFactory.getLogger(FigmaAdminController.class);
    private final HostHelper helper;
    private final FigmaHelper figmaHelper;

    FigmaAdminController(FigmaHelper figmaHelper, HostHelper helper) {
        this.figmaHelper = figmaHelper;
        this.helper = helper;
    }

    @GET
    @Path(value="/connect")
    public Response connect() {
        if (!this.helper.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.getUserOrError("");
    }

    @GET
    @Path(value="/user")
    public Response user(@QueryParam(value="token") String token) {
        if (!this.helper.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.getUserOrError(token);
    }

    @GET
    @Path(value="/check")
    public Response hasAccess(@QueryParam(value="key") String key, @QueryParam(value="type") String type) {
        if (!this.helper.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.figmaHelper.hasAccess(key, type);
    }

    @GET
    @Path(value="/validate")
    public Response validate(@QueryParam(value="token") String token, @QueryParam(value="key") String key) {
        if (!this.helper.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.figmaHelper.validate(token, key);
    }

    @GET
    @Path(value="/version")
    public Response version(@QueryParam(value="id") String id, @QueryParam(value="key") String key, @QueryParam(value="forceRefresh") String forceRefresh) {
        if (!this.helper.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.figmaHelper.version(id, key, forceRefresh);
    }

    @GET
    @Path(value="/versions")
    public Response versions(@QueryParam(value="key") String key, @QueryParam(value="after") String after, @QueryParam(value="before") String before, @QueryParam(value="limit") String limit, @QueryParam(value="forceRefresh") String forceRefresh) {
        if (!this.helper.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.figmaHelper.versions(key, after, before, limit, forceRefresh);
    }

    @GET
    @Path(value="/preview")
    public Response preview(@QueryParam(value="key") String key, @QueryParam(value="nodeId") String nodeId, @QueryParam(value="revision") String revision, @QueryParam(value="scale") String scale, @QueryParam(value="format") String format) {
        if (!this.helper.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.figmaHelper.preview(key, nodeId, revision, scale, format);
    }

    @GET
    @Path(value="/view")
    public Response view(@QueryParam(value="id") String id, @QueryParam(value="revision") String revision, @QueryParam(value="scale") String scale, @QueryParam(value="format") String format, @QueryParam(value="forceRefresh") String forceRefresh) {
        if (!this.helper.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.figmaHelper.view(id, revision, scale, format, forceRefresh);
    }

    @GET
    @Path(value="/legacy")
    public Response legacyMacroView(@QueryParam(value="contentId") String contentId, @QueryParam(value="macroId") String macroId, @QueryParam(value="scale") String scale, @QueryParam(value="format") String format, @QueryParam(value="forceRefresh") String forceRefresh) {
        if (!this.helper.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.figmaHelper.legacyMacroView(contentId, macroId, scale, format, forceRefresh);
    }

    @GET
    @Path(value="/download")
    public Response download(@QueryParam(value="id") String id, @QueryParam(value="revision") String revision, @QueryParam(value="scale") String scale, @QueryParam(value="format") String format) {
        if (!this.helper.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.figmaHelper.download(id, revision, scale, format);
    }

    private Response getUserOrError(String token) {
        try {
            FigmaService figmaService = new FigmaService(token);
            return Response.ok((Object)figmaService.getUser()).build();
        }
        catch (Exception exp) {
            if (exp.getMessage().startsWith("403")) {
                return Response.ok((Object)new FigmaErrorDTO(403, "Invalid token")).build();
            }
            log.error("An unexpected error occurred", (Throwable)exp);
            return Response.ok((Object)new FigmaErrorDTO(500, exp.getMessage())).build();
        }
    }
}

