/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.controllers;

import app.figma.server.HostHelper;
import app.figma.server.api.v100000000.controllers.AbstractController;
import app.figma.server.api.v100000000.dto.DTO;
import app.figma.server.api.v100000000.dto.PageDTO;
import app.figma.server.api.v100000000.services.Service;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.java.ao.Entity;
import org.springframework.web.server.ResponseStatusException;

public abstract class DefaultController<T extends Entity, X extends DTO>
extends AbstractController<T, X> {
    DefaultController(Service<T, X> service, HostHelper helper) {
        super(service, helper);
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response readRequest(@Context UriInfo ctx) {
        try {
            PageDTO result = super.read(ctx);
            return Response.ok(result).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response readRequest(@PathParam(value="id") int id) {
        try {
            Object result = super.read(id);
            return Response.ok(result).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response createRequest(X item) {
        try {
            X result = super.create(item);
            return Response.ok(result).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response updateRequest(@PathParam(value="id") int id, X item) {
        try {
            X result = super.update(id, item);
            return Response.ok(result).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response removeRequest(@PathParam(value="id") int id) {
        try {
            super.remove(id);
            return Response.noContent().build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }
}

