/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.controllers;

import app.figma.server.HostHelper;
import app.figma.server.api.v100000000.controllers.AbstractController;
import app.figma.server.api.v100000000.controllers.DefaultController;
import app.figma.server.api.v100000000.dto.CacheSettingsDTO;
import app.figma.server.api.v100000000.services.CacheSettingsService;
import app.figma.server.entities.CacheSettings;
import com.atlassian.cache.CacheManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.springframework.web.server.ResponseStatusException;

@Path(value="/cache")
public class CacheSettingsController
extends DefaultController<CacheSettings, CacheSettingsDTO> {
    private final CacheManager cacheManager;

    CacheSettingsController(HostHelper helper, CacheSettingsService cacheSettingsService, @ComponentImport CacheManager cacheManager) {
        super(cacheSettingsService, helper);
        this.cacheManager = cacheManager;
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, UriInfo context) {
        return this.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER);
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, int id) {
        return this.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER);
    }

    @Override
    protected boolean isAllowed(AbstractController.RequestType action, CacheSettingsDTO item) {
        return this.hasGlobalPermission(HostHelper.HostPermission.ADMINISTER);
    }

    @Override
    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response updateRequest(@PathParam(value="id") int id, CacheSettingsDTO item) {
        try {
            CacheSettingsDTO result = super.update(id, item);
            this.cacheManager.flushCaches();
            return Response.ok((Object)result).build();
        }
        catch (ResponseStatusException exception) {
            return this.toResponseStatus(exception);
        }
    }
}

