/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server.api.v100000000.controllers;

import app.figma.server.HostHelper;
import app.figma.server.api.v100000000.dto.DTO;
import app.figma.server.api.v100000000.dto.PageDTO;
import app.figma.server.api.v100000000.helpers.Page;
import app.figma.server.api.v100000000.services.Service;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.java.ao.Entity;
import net.java.ao.Query;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ResponseStatusException;

public abstract class AbstractController<T extends Entity, X extends DTO> {
    protected Service<T, X> service;
    protected final HostHelper helper;

    AbstractController(Service<T, X> service, HostHelper helper) {
        this.service = service;
        this.helper = helper;
    }

    protected abstract boolean isAllowed(RequestType var1, UriInfo var2);

    protected abstract boolean isAllowed(RequestType var1, int var2);

    protected abstract boolean isAllowed(RequestType var1, X var2);

    protected boolean hasGlobalPermission(HostHelper.HostPermission permission) {
        return this.helper.hasGlobalPermission(permission);
    }

    protected PageDTO<X> read(UriInfo ctx) throws ResponseStatusException {
        if (!this.isAllowed(RequestType.LIST, ctx)) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        Query query = this.toQuery(ctx);
        Page<T> result = query != null ? this.service.findAll(query) : this.service.findAll();
        return PageDTO.from(result, this.service::toDTO);
    }

    protected X read(int id) throws ResponseStatusException {
        if (!this.isAllowed(RequestType.READ, id)) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        T result = this.service.findById(id);
        if (result != null) {
            return this.service.toDTO(result);
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND);
    }

    protected X create(X item) throws ResponseStatusException {
        int entityId;
        int n = entityId = !Strings.isNullOrEmpty((String)((DTO)item).getId()) ? Integer.parseInt(((DTO)item).getId()) : -1;
        if (entityId > 0 || !this.service.isValidEntity(item)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST);
        }
        if (!this.isAllowed(RequestType.CREATE, item)) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        T result = this.service.toEntity(item, this.service.createOrUpdate(item));
        result.save();
        return this.service.toDTO(result);
    }

    protected X update(int id, X item) throws ResponseStatusException {
        int entityId;
        int n = entityId = !Strings.isNullOrEmpty((String)((DTO)item).getId()) ? Integer.parseInt(((DTO)item).getId()) : -1;
        if (entityId <= 0 || entityId != id || !this.service.isValidEntity(item)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST);
        }
        if (!this.isAllowed(RequestType.UPDATE, item)) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        T entity = this.service.findById(entityId);
        if (entity != null) {
            T result = this.service.toEntity(item, entity);
            result.save();
            return this.service.toDTO(result);
        }
        throw new ResponseStatusException(HttpStatus.BAD_REQUEST);
    }

    protected void remove(int id) throws ResponseStatusException {
        if (!this.isAllowed(RequestType.DELETE, id)) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        this.service.delete(id);
    }

    protected Response toResponseStatus(ResponseStatusException exception) {
        Response.Status status = Response.Status.fromStatusCode((int)exception.getRawStatusCode());
        return Response.status((Response.Status)status).build();
    }

    protected Query toQuery(UriInfo ctx) {
        return this.toQuery(ctx, null, null);
    }

    protected Query toQuery(UriInfo ctx, @Nullable String fields) {
        return this.toQuery(ctx, fields, null);
    }

    protected Query toQuery(UriInfo ctx, @Nullable QueryBuilder queryBuilder) {
        return this.toQuery(ctx, null, queryBuilder);
    }

    protected Query toQuery(UriInfo ctx, @Nullable String fields, @Nullable QueryBuilder queryBuilder) {
        Query query = fields != null ? Query.select((String)fields) : Query.select();
        try {
            MultivaluedMap querystring = ctx.getQueryParameters();
            for (String key : querystring.keySet()) {
                String value = (String)querystring.getFirst((Object)key);
                query = this.defaultQueryBuilder(queryBuilder).apply(key, value, query);
            }
            return query;
        }
        catch (IllegalArgumentException ignored) {
            return query;
        }
    }

    private QueryBuilder defaultQueryBuilder(@Nullable QueryBuilder extendedBuilder) {
        return (key, value, query) -> {
            switch (key) {
                case "limit": {
                    query = query.limit(Integer.parseInt(value));
                    break;
                }
                case "offset": {
                    query = query.offset(Integer.parseInt(value));
                    break;
                }
                case "order": {
                    query = query.order(value);
                    break;
                }
                default: {
                    query = extendedBuilder != null ? extendedBuilder.apply(key, value, query) : query;
                }
            }
            return query;
        };
    }

    protected Query addWhereClause(Query query, String clause, Object ... params) {
        String whereClause = query.getWhereClause();
        if (whereClause != null && !whereClause.isEmpty()) {
            clause = (String)clause + " AND " + whereClause;
            params = Stream.concat(Arrays.stream(params), Arrays.stream(query.getWhereParams())).toArray();
        }
        query.where((String)clause, params);
        return query;
    }

    @FunctionalInterface
    public static interface QueryBuilder {
        public Query apply(String var1, String var2, Query var3);
    }

    protected static enum RequestType {
        READ,
        LIST,
        CREATE,
        UPDATE,
        DELETE;

    }
}

