/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server;

import app.figma.server.api.v100000000.dto.FigmaMetadataDTO;
import app.figma.server.api.v100000000.dto.FigmaUserDTO;
import app.figma.server.api.v100000000.dto.FigmaVersionDTO;
import app.figma.server.api.v100000000.helpers.NodeTree;
import com.figma.api.FigmaAPI;
import com.figma.api.dto.Document;
import com.figma.api.dto.File;
import com.figma.api.dto.FileRequest;
import com.figma.api.dto.Images;
import com.figma.api.dto.ImagesFormat;
import com.figma.api.dto.ImagesRequest;
import com.figma.api.dto.Node;
import com.figma.api.dto.Rect;
import com.figma.api.dto.User;
import com.figma.api.dto.Version;
import com.figma.api.dto.withChildren;
import com.figma.api.dto.withDimensions;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FigmaService {
    private static final Logger log = LoggerFactory.getLogger(FigmaService.class);
    private final FigmaAPI client;

    public FigmaService(String token) {
        this.client = new FigmaAPI(token);
    }

    public FigmaUserDTO getUser() throws IOException {
        try {
            User user = this.client.getUser();
            return new FigmaUserDTO(user);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public FigmaVersionDTO getLatestVersion(String key) throws IOException {
        try {
            Version version = this.client.getLatestVersion(key);
            return version != null ? new FigmaVersionDTO(version) : null;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public FigmaVersionDTO getVersion(String id, String key) throws IOException {
        try {
            Version version = this.client.getVersion(id, key);
            return version != null ? new FigmaVersionDTO(version) : null;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public List<FigmaVersionDTO> getVersions(String key) throws IOException {
        return this.getVersions(key, null);
    }

    public List<FigmaVersionDTO> getVersions(String key, String after) throws IOException {
        return this.getVersions(key, after, null);
    }

    public List<FigmaVersionDTO> getVersions(String key, String after, String before) throws IOException {
        return this.getVersions(key, after, before, null);
    }

    public List<FigmaVersionDTO> getVersions(String key, String after, String before, String limit) throws IOException {
        try {
            List<Version> versions = this.client.getVersions(key, after, before, limit);
            return versions.stream().map(FigmaVersionDTO::new).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public FigmaMetadataDTO getMetadata(String key) {
        return this.getMetadata(key, "0:1");
    }

    public FigmaMetadataDTO getMetadata(String key, String nodeId) {
        return this.getMetadata(key, nodeId, null);
    }

    public FigmaMetadataDTO getMetadata(String key, String nodeId, String version) {
        try {
            String id = null != nodeId ? nodeId.replace("-", ":") : "0:1";
            File mainFile = this.client.getFile(key, FileRequest.builder().depth(0).nodeId(id).branchData(true).build());
            File revisionFile = null != version && !version.isEmpty() ? this.client.getFile(key, FileRequest.builder().depth(0).nodeId(id).version(version).build()) : null;
            File parentFile = null != mainFile.getMainFileKey() && !mainFile.getMainFileKey().isEmpty() ? this.client.getFile(mainFile.getMainFileKey(), FileRequest.builder().depth(1).nodeId("0:0").build()) : null;
            FigmaMetadataDTO.ParentFile parent = null != parentFile ? FigmaMetadataDTO.ParentFile.builder().key(mainFile.getMainFileKey()).name(parentFile.getName()).lastModified(parentFile.getLastModified()).build() : null;
            FigmaVersionDTO latestVersion = this.getLatestVersion(key);
            FigmaVersionDTO currentVersion = null != version && !version.isEmpty() ? this.getVersion(version, key) : this.getVersion(mainFile.getVersion(), key);
            Document document = null != revisionFile ? revisionFile.getDocument() : mainFile.getDocument();
            NodeTree rootNode = this.toNodeTree(document);
            NodeTree node = this.findNode(rootNode.getChildren(), id);
            if (null != node) {
                NodeTree canvas = this.findParentNodeByType(node, "CANVAS");
                String backgroundColor = null != canvas ? String.format("rgba(%s, %s, %s, %s)", canvas.getBackgroundColor().getR() * 255.0, canvas.getBackgroundColor().getG() * 255.0, canvas.getBackgroundColor().getB() * 255.0, canvas.getBackgroundColor().getA()) : "#fff";
                FigmaMetadataDTO result = new FigmaMetadataDTO();
                result.setId(key);
                result.setName(node.getName());
                result.setFileName(mainFile.getName());
                result.setLastModified(mainFile.getLastModified());
                result.setBackgroundColor(backgroundColor);
                result.setWidth(node.getWidth());
                result.setHeight(node.getHeight());
                result.setVersion(currentVersion);
                result.setLatestVersion(latestVersion);
                result.setParent(parent);
                return result;
            }
            FigmaMetadataDTO result = new FigmaMetadataDTO();
            result.setId(key);
            result.setName(mainFile.getName());
            result.setFileName(mainFile.getName());
            result.setBackgroundColor("#fff");
            result.setLastModified(mainFile.getLastModified());
            return result;
        }
        catch (IOException | URISyntaxException e) {
            return null;
        }
    }

    public Map<String, String> getImageURLs(String key) throws IOException {
        return this.getImageURLs(key, "0:1");
    }

    public Map<String, String> getImageURLs(String key, String nodeId) throws IOException {
        return this.getImageURLs(key, nodeId, null);
    }

    public Map<String, String> getImageURLs(String key, String nodeId, String version) throws IOException {
        return this.getImageURLs(key, nodeId, version, 1.0);
    }

    public Map<String, String> getImageURLs(String key, String nodeId, String version, double scale) throws IOException {
        return this.getImageURLs(key, nodeId, version, scale, ImagesFormat.svg);
    }

    public Map<String, String> getImageURLs(String key, String nodeId, String version, double scale, ImagesFormat format) throws IOException {
        try {
            ImagesRequest options = ImagesRequest.builder().nodeId(nodeId).version(version).scale(scale).format(format).build();
            Images images = this.client.getImage(key, options);
            return images.getImages();
        }
        catch (Exception exp) {
            throw new IOException(exp.getMessage());
        }
    }

    private NodeTree toNodeTree(Node node) {
        return this.toNodeTree(node, null);
    }

    private NodeTree toNodeTree(Node node, NodeTree parent) {
        Rect absoluteBoundingBox = node instanceof withDimensions ? ((withDimensions)((Object)node)).getAbsoluteBoundingBox() : null;
        Double width = absoluteBoundingBox != null ? Double.valueOf(absoluteBoundingBox.getWidth()) : null;
        Double height = absoluteBoundingBox != null ? Double.valueOf(absoluteBoundingBox.getHeight()) : null;
        NodeTree result = NodeTree.builder().id(node.getId()).name(node.getName()).type(node.getType()).backgroundColor(node.getBackgroundColor()).width(width).height(height).parent(parent).build();
        if (node instanceof withChildren) {
            result.setChildren(Arrays.stream(((withChildren)((Object)node)).getChildren()).map(entry -> this.toNodeTree((Node)entry, result)).collect(Collectors.toList()));
        }
        return result;
    }

    private NodeTree findNode(List<NodeTree> nodes, String id) {
        return nodes.stream().reduce(null, (returnValue, nextItem) -> {
            if (returnValue != null) {
                return returnValue;
            }
            if (nextItem.getId().equals(id)) {
                return nextItem;
            }
            if (nextItem.getChildren() != null) {
                return this.findNode(nextItem.getChildren(), id);
            }
            return null;
        });
    }

    private NodeTree findParentNodeByType(NodeTree node, String type) {
        if (node.getType() != null && node.getType().equalsIgnoreCase(type)) {
            return node;
        }
        if (node.getParent() != null) {
            return this.findParentNodeByType(node.getParent(), type);
        }
        return null;
    }
}

