/*
 * Decompiled with CFR 0.152.
 */
package app.figma.server;

import app.figma.server.Constants;
import app.figma.server.FigmaService;
import app.figma.server.api.v100000000.dto.FigmaMetadataDTO;
import app.figma.server.api.v100000000.dto.FigmaUserDTO;
import app.figma.server.api.v100000000.dto.FigmaVersionDTO;
import app.figma.server.api.v100000000.services.CacheSettingsService;
import app.figma.server.entities.CacheSettings;
import app.figma.server.events.AOReadyEvent;
import app.figma.server.helpers.CacheKey;
import app.figma.server.helpers.Option;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.figma.api.dto.ImagesFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.java.ao.Query;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Figma
implements LifecycleAware,
InitializingBean,
DisposableBean {
    private Cache<CacheKey<CachedMethods>, Option<?>> cache = null;
    private final CacheManager cacheManager;
    private final CacheSettingsService cacheSettingsService;
    private final EventPublisher eventPublisher;

    @Autowired
    Figma(@ComponentImport CacheManager cacheManager, CacheSettingsService cacheSettingsService, @ComponentImport EventPublisher eventPublisher) {
        this.cacheManager = cacheManager;
        this.cacheSettingsService = cacheSettingsService;
        this.eventPublisher = eventPublisher;
    }

    public FigmaUserDTO user(String token) {
        CacheKey<CachedMethods> cacheKey = CacheKey.builder().method(CachedMethods.USER).parameter("token", token).key("token", token).build();
        return (FigmaUserDTO)this.fetch(cacheKey, true);
    }

    public boolean validate(String token, String key, boolean forceRefresh) {
        CacheKey<CachedMethods> cacheKey = CacheKey.builder().method(CachedMethods.VALIDATE).key("key", key).key("token", token).build();
        return Boolean.TRUE.equals(this.fetch(cacheKey, forceRefresh));
    }

    public FigmaVersionDTO latestVersion(String token, String key, boolean forceRefresh) {
        CacheKey<CachedMethods> cacheKey = CacheKey.builder().method(CachedMethods.LATESTVERSION).parameter("token", token).key("key", key).build();
        return (FigmaVersionDTO)this.fetch(cacheKey, forceRefresh);
    }

    public FigmaVersionDTO version(String token, String version, String key, boolean forceRefresh) {
        CacheKey<CachedMethods> cacheKey = CacheKey.builder().method(CachedMethods.VERSION).parameter("token", token).key("id", version).key("key", key).build();
        return (FigmaVersionDTO)this.fetch(cacheKey, forceRefresh);
    }

    public List<FigmaVersionDTO> versions(String token, String key, boolean forceRefresh) {
        return this.versions(token, key, null, forceRefresh);
    }

    public List<FigmaVersionDTO> versions(String token, String key, String after, boolean forceRefresh) {
        return this.versions(token, key, after, null, forceRefresh);
    }

    public List<FigmaVersionDTO> versions(String token, String key, String after, String before, boolean forceRefresh) {
        return this.versions(token, key, after, before, null, forceRefresh);
    }

    public List<FigmaVersionDTO> versions(String token, String key, String after, String before, String limit, boolean forceRefresh) {
        CacheKey<CachedMethods> cacheKey = CacheKey.builder().method(CachedMethods.VERSIONS).parameter("token", token).key("key", key).key("after", after).key("before", before).key("limit", limit).build();
        return (List)this.fetch(cacheKey, forceRefresh);
    }

    public FigmaMetadataDTO metadata(String token, String key, boolean forceRefresh) {
        return this.metadata(token, key, "0:1", forceRefresh);
    }

    public FigmaMetadataDTO metadata(String token, String key, String nodeId, boolean forceRefresh) {
        return this.metadata(token, key, nodeId, null, forceRefresh);
    }

    public FigmaMetadataDTO metadata(String token, String key, String nodeId, String revision, boolean forceRefresh) {
        CacheKey<CachedMethods> cacheKey = CacheKey.builder().method(CachedMethods.METADATA).parameter("token", token).key("key", key).key("nodeId", nodeId).key("revision", revision).build();
        return (FigmaMetadataDTO)this.fetch(cacheKey, forceRefresh);
    }

    public String imageUrls(String token, String key, String nodeId, String revision, String scale, ImagesFormat format, boolean forceRefresh) {
        CacheKey<CachedMethods> cacheKey = CacheKey.builder().method(CachedMethods.IMAGEURLS).parameter("token", token).key("key", key).key("nodeId", nodeId).key("revision", revision).key("scale", scale).key("format", format.name()).build();
        return (String)this.fetch(cacheKey, forceRefresh);
    }

    private <T> T fetch(CacheKey<CachedMethods> cacheKey, boolean forceRefresh) {
        if (null != this.cache) {
            Option result;
            if (forceRefresh) {
                this.cache.remove(cacheKey);
            }
            return null != (result = (Option)this.cache.get(cacheKey)) ? (T)result.getValue() : null;
        }
        Option result = (Option)this.getCacheLoader().load(cacheKey);
        return result.getValue();
    }

    private CacheLoader<CacheKey<CachedMethods>, Option<?>> getCacheLoader() {
        return new CacheLoader<CacheKey<CachedMethods>, Option<?>>(){

            @Nonnull
            public Option<?> load(@Nonnull CacheKey<CachedMethods> cacheKey) {
                try {
                    CachedMethods method = cacheKey.getMethod();
                    Map<String, String> params = cacheKey.getParameters();
                    String token = params.getOrDefault("token", null);
                    if (null == token) {
                        throw new IllegalArgumentException("Token parameter is required");
                    }
                    FigmaService figmaService = new FigmaService(token);
                    switch (method) {
                        case USER: {
                            try {
                                return new Option<FigmaUserDTO>(figmaService.getUser());
                            }
                            catch (Exception ignored) {
                                return new Option<Object>(null);
                            }
                        }
                        case VALIDATE: {
                            try {
                                String key = params.getOrDefault("key", null);
                                if (null == key) {
                                    throw new IOException();
                                }
                                FigmaMetadataDTO metadata = figmaService.getMetadata(key);
                                return new Option<Boolean>(null != metadata);
                            }
                            catch (Exception ignored) {
                                return new Option<Boolean>(false);
                            }
                        }
                        case LATESTVERSION: {
                            try {
                                String key = params.getOrDefault("key", null);
                                if (null == key) {
                                    throw new IOException();
                                }
                                return new Option<FigmaVersionDTO>(figmaService.getLatestVersion(key));
                            }
                            catch (Exception ignored) {
                                return new Option<Object>(null);
                            }
                        }
                        case VERSION: {
                            try {
                                String id = params.getOrDefault("id", null);
                                String key = params.getOrDefault("key", null);
                                if (null == id || null == key) {
                                    throw new IOException();
                                }
                                return new Option<FigmaVersionDTO>(figmaService.getVersion(id, key));
                            }
                            catch (Exception ignored) {
                                return new Option<Object>(null);
                            }
                        }
                        case VERSIONS: {
                            try {
                                String key = params.getOrDefault("key", null);
                                String after = params.getOrDefault("after", null);
                                String before = params.getOrDefault("before", null);
                                String limit = params.getOrDefault("limit", null);
                                if (null == key) {
                                    throw new IOException();
                                }
                                List<FigmaVersionDTO> versions = figmaService.getVersions(key, after, before, limit);
                                return new Option<ArrayList<FigmaVersionDTO>>(new ArrayList<FigmaVersionDTO>(versions));
                            }
                            catch (Exception ignored) {
                                return new Option<Object>(null);
                            }
                        }
                        case METADATA: {
                            try {
                                String key = params.getOrDefault("key", null);
                                String nodeId = params.getOrDefault("nodeId", "0:1");
                                String revision = params.getOrDefault("revision", null);
                                if (null == key) {
                                    throw new IOException();
                                }
                                return new Option<FigmaMetadataDTO>(figmaService.getMetadata(key, nodeId, revision));
                            }
                            catch (Exception ignored) {
                                return new Option<Object>(null);
                            }
                        }
                        case IMAGEURLS: {
                            try {
                                String key = params.getOrDefault("key", null);
                                String nodeId = params.getOrDefault("nodeId", "0:1");
                                String revision = params.getOrDefault("revision", null);
                                String scale = params.getOrDefault("scale", "1");
                                String format = params.getOrDefault("format", ImagesFormat.svg.name());
                                if (null == key) {
                                    throw new IOException();
                                }
                                Map<String, String> images = figmaService.getImageURLs(key, nodeId, revision, Double.parseDouble(scale), ImagesFormat.valueOf(format));
                                if (images.containsKey(nodeId)) {
                                    return new Option<String>(images.get(nodeId));
                                }
                                if (images.containsKey(nodeId.replace('-', ':'))) {
                                    return new Option<String>(images.get(nodeId.replace('-', ':')));
                                }
                                return new Option<String>(images.get("0:1"));
                            }
                            catch (IOException e) {
                                return new Option<Object>(null);
                            }
                        }
                    }
                    throw new IllegalArgumentException();
                }
                catch (IllegalArgumentException ignored) {
                    return new Option<Object>(null);
                }
            }
        };
    }

    public void onStart() {
    }

    public void onStop() {
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onAOReadyEvent(AOReadyEvent event) {
        block4: {
            try {
                CacheSettings settings = (CacheSettings)this.cacheSettingsService.findOne(Query.select().limit(1).offset(0));
                if (null == settings || !settings.isEnabled()) break block4;
                int timeout = settings.getTimeout() > 0 ? settings.getTimeout() : 30;
                int maxEntries = settings.getMaxEntries() > 0 ? settings.getMaxEntries() : 50;
                Constants.CacheExpirationPolicy policy = Constants.CacheExpirationPolicy.EXPIRE_AFTER_WRITE;
                try {
                    policy = Constants.CacheExpirationPolicy.valueOf(settings.getExpirationPolicy());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                CacheSettingsBuilder cacheSettingsBuilder = new CacheSettingsBuilder().remote().maxEntries(maxEntries);
                cacheSettingsBuilder = policy.equals((Object)Constants.CacheExpirationPolicy.EXPIRE_AFTER_WRITE) ? cacheSettingsBuilder.expireAfterWrite((long)timeout, TimeUnit.MINUTES) : cacheSettingsBuilder.expireAfterAccess((long)timeout, TimeUnit.MINUTES);
                this.cache = this.cacheManager.getCache(this.getClass().getCanonicalName(), this.getCacheLoader(), cacheSettingsBuilder.build());
            }
            catch (Exception ignored) {
                this.cache = null;
            }
        }
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    private static enum CachedMethods {
        USER,
        VALIDATE,
        LATESTVERSION,
        VERSION,
        VERSIONS,
        METADATA,
        IMAGEURLS;

    }
}

